

<?php $__env->startSection('title', 'Department of Kayachikitsa | Ayurvedic Internal Medicine and Clinical Therapeutics'); ?>
<?php $__env->startSection('meta_description', 'Department of Kayachikitsa providing Ayurvedic internal medicine, OPD and IPD clinical
    services, chronic disease management, Panchakarma integration, and evidence-based Ayurvedic therapeutics for students
    and patients.'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Optional: Add your custom styles here -->
    <style>
        /* =========================
        GLOBAL STYLES
        ========================= */

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', 'Open Sans', Arial, sans-serif;
            font-size: 16px;
            line-height: 1.7;
            color: #333;
            background-color: #ffffff;
        }


        ul {
            list-style-image: url('bullet.png');
            /* Path to your bullet image */
            list-style-type: disc;
            /* Fallback if image is not available */
        }

        h1,
        h2,
        h3 {
            font-family: 'Poppins', 'Montserrat', sans-serif;
            color: #1f2a44;
            margin-bottom: 15px;
        }

        h1 {
            font-size: 36px;
        }

        h2 {
            font-size: 28px;
        }

        p {
            margin-bottom: 15px;
        }

        a {
            text-decoration: none;
            color: #1a4ed8;
        }

        a:hover {
            text-decoration: underline;
        }

        /* =========================
                                                    LAYOUT
                                                    ========================= */

        .container {
            max-width: 1100px;
            margin: auto;
            padding: 0 20px;
        }

        .section {
            padding: 60px 0;
        }

        .bg-light {
            background-color: #f7f9fc;
        }

        .bg-primary {
            background-color: #1f2a44;
        }

        /* =========================
                                                    HERO SECTION
                                                    ========================= */

        .hero-section {
            background: linear-gradient(rgba(31, 42, 68, 0.7),
                    rgba(31, 42, 68, 0.7)),
                url('campus-photo.jpg') center/cover no-repeat;
            text-align: center;
            padding: 100px 20px;
            color: #ffffff;
        }

        .hero-section h1 {
            color: #ffffff;
            font-size: 42px;
        }

        .hero-section p {
            font-size: 18px;
            margin-bottom: 30px;
        }

        /* =========================
                                                    BUTTONS
                                                    ========================= */

        .btn {
            display: inline-block;
            padding: 12px 26px;
            margin: 5px;
            border-radius: 6px;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .btn.primary {
            background-color: #f0b429;
            color: #1f2a44;
        }

        .btn.primary:hover {
            background-color: #d99b1f;
        }

        .btn.secondary {
            background-color: transparent;
            border: 2px solid #ffffff;
            color: #ffffff;
        }

        .btn.secondary:hover {
            background-color: #ffffff;
            color: #1f2a44;
        }

        /* =========================
                                                    LISTS & CONTENT
                                                    ========================= */

        .strength-list,
        .leadership-list,
        .important-links {
            list-style: none;
            padding-left: 0;
        }

        .strength-list li,
        .leadership-list li {
            padding: 10px 0;
            padding-left: 28px;
            position: relative;
        }

        .strength-list li::before {
            content: "✔";
            position: absolute;
            left: 0;
            color: #1a4ed8;
            font-weight: bold;
        }

        /* =========================
                                                    FACILITIES GRID
                                                    ========================= */

        .facility-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
            gap: 20px;
            margin-top: 30px;
        }

        .facility-item {
            background: #c9c7bf;
            padding: 25px;
            text-align: center;
            border-radius: 10px;
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.08);
            font-weight: 600;
        }

        /* =========================
                                                    LINKS SECTION
                                                    ========================= */

        .important-links li {
            margin-bottom: 10px;
        }

        .important-links a {
            color: #ffffff;
            font-weight: 500;
        }

        .section {
            padding: 30px 0;
        }

        /* =========================
                                                    FOOTER
                                                    ========================= */

        .footer {
            background-color: #f1f3f6;
            text-align: center;
            font-size: 14px;
            color: #666;
        }

        .footer p {
            margin: 0;
        }

        /* =========================
                                                    RESPONSIVE DESIGN
                                                    ========================= */

        @media (max-width: 768px) {
            h1 {
                font-size: 30px;
            }

            h2 {
                font-size: 24px;
            }

            .hero-section {
                padding: 70px 20px;
            }

            .btn {
                width: 100%;
                max-width: 280px;
            }
        }
    </style>
    <div class="container my-5">

        <!-- ================= PAGE HEADER ================= -->
        <header class="text-center mb-5">
            <h1 class="fw-bold">Department of Kayachikitsa</h1>
            <p class="text-muted">
                Ayurvedic Internal Medicine • Clinical Therapeutics • OPD/IPD Care • Chronic Disease Management
            </p>
        </header>


        <!-- ================= Department Overview ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Department Overview</h2>

            <p class="text-justify">
                The Department of Kayachikitsa represents the core clinical discipline of Ayurveda,
                focusing on internal medicine and comprehensive patient care. The department trains
                students in diagnosis, treatment planning, and management of acute and chronic diseases
                through classical Ayurvedic therapies including herbal medicines, Panchakarma procedures,
                dietary regulation, and lifestyle modification. With strong OPD and IPD exposure, students
                gain real-time clinical competence and evidence-based therapeutic skills.
            </p>

            <ul>
                <li>Management of systemic and metabolic disorders</li>
                <li>Clinical diagnosis using Ayurvedic and modern parameters</li>
                <li>Panchakarma-assisted therapeutic care</li>
                <li>Holistic treatment approach for long-term wellness</li>
            </ul>
        </section>


        <!-- ================= Vision & Mission ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Vision & Mission</h2>

            <div class="row g-4">

                <div class="col-md-6">
                    <div class="card shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-semibold">Vision</h5>
                            <p>
                                To deliver excellence in Ayurvedic internal medicine by integrating classical
                                therapeutic wisdom with modern clinical standards for safe and effective care.
                            </p>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="card shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-semibold">Mission</h5>
                            <ul>
                                <li>Provide quality patient-centered treatment</li>
                                <li>Enhance hands-on clinical training</li>
                                <li>Encourage clinical research and documentation</li>
                                <li>Promote ethical and evidence-based practice</li>
                            </ul>
                        </div>
                    </div>
                </div>

            </div>
        </section>


        <!-- ================= Courses ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Courses & Teaching Programs</h2>

            <div class="table-responsive">
                <table class="table table-bordered table-striped align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>Program</th>
                            <th>Year</th>
                            <th>Subject</th>
                            <th>Component</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>BAMS</td>
                            <td>Final Professional</td>
                            <td>Kayachikitsa</td>
                            <td>Theory + Clinical Posting</td>
                        </tr>
                        <tr>
                            <td>BAMS</td>
                            <td>Internship</td>
                            <td>Clinical Training</td>
                            <td>OPD/IPD Practice</td>
                        </tr>
                        <tr>
                            <td>MD (PG)</td>
                            <td>Specialization</td>
                            <td>Advanced Internal Medicine</td>
                            <td>Research + Clinical Work</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </section>


        <!-- ================= Faculty ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Faculty & Staff</h2>

            <div class="row g-4">

                <div class="col-md-4">
                    <div class="card text-center shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-bold">Dr. A. Sharma</h5>
                            <p class="text-muted mb-1">Professor & Head</p>
                            <small>MD (Kayachikitsa) | 20+ Years Clinical Experience</small>
                        </div>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="card text-center shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-bold">Dr. M. Rao</h5>
                            <p class="text-muted mb-1">Associate Professor</p>
                            <small>Chronic Disease Management Specialist</small>
                        </div>
                    </div>
                </div>

            </div>
        </section>


        <!-- ================= Infrastructure ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Infrastructure & Facilities</h2>

            <div class="row row-cols-1 row-cols-md-2 g-2">
                <div class="col">✔ Dedicated OPD Consultation Rooms</div>
                <div class="col">✔ IPD Wards with Bed Facilities</div>
                <div class="col">✔ Panchakarma Therapy Unit</div>
                <div class="col">✔ Diagnostic Support Laboratory</div>
                <div class="col">✔ Pharmacy & Medicine Dispensing Unit</div>
                <div class="col">✔ Smart Classroom & Case Discussion Hall</div>
            </div>
        </section>


        <!-- ================= Teaching Methodology ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Teaching Methodology</h2>

            <ul>
                <li>Case-based clinical teaching</li>
                <li>Daily ward rounds and patient interaction</li>
                <li>Therapeutic procedure demonstrations</li>
                <li>Seminars, case presentations, and journal clubs</li>
                <li>Integration of classical texts with clinical practice</li>
            </ul>
        </section>


        <!-- ================= Research ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Research & Publications</h2>

            <ul>
                <li>Clinical trials on Ayurvedic formulations</li>
                <li>Chronic disease outcome studies</li>
                <li>Integrative medicine research projects</li>
                <li>National and international journal publications</li>
            </ul>
        </section>


        <!-- ================= Activities ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Academic & Co-Curricular Activities</h2>

            <ul>
                <li>Health camps and community outreach programs</li>
                <li>Clinical workshops and CMEs</li>
                <li>Guest lectures by experienced physicians</li>
                <li>Interdisciplinary medical conferences</li>
            </ul>
        </section>


        <!-- ================= Student Support ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Student Support</h2>

            <ul>
                <li>Clinical case sheets and logbooks</li>
                <li>Mentorship and bedside teaching guidance</li>
                <li>Research supervision for dissertations</li>
                <li>Internship and career counseling</li>
            </ul>
        </section>


        <!-- ================= Gallery ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Photo & Media Gallery</h2>

            <div class="row g-3">
                <div class="col-md-3">
                    <img src="/images/kaya1.jpg" class="img-fluid rounded" alt="OPD Consultation">
                </div>
                <div class="col-md-3">
                    <img src="/images/kaya2.jpg" class="img-fluid rounded" alt="IPD Ward Facility">
                </div>
                <div class="col-md-3">
                    <img src="/images/kaya3.jpg" class="img-fluid rounded" alt="Panchakarma Therapy">
                </div>
                <div class="col-md-3">
                    <img src="/images/kaya4.jpg" class="img-fluid rounded" alt="Clinical Teaching Session">
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\RKDF_New_Websites\new_rkcams.in\resources\views/Kayachikitsa.blade.php ENDPATH**/ ?>