<title>Contact Us | Ram Krishna College of Ayurveda, RKDF University</title>
<meta name="description"
    content="Contact Ram Krishna College of Ayurveda (RKCAMS), RKDF University Bhopal for admissions, courses, campus visit, and academic queries.">
<meta name="keywords"
    content="RKCAMS contact, Ayurveda college Bhopal, RKDF University Ayurveda, BAMS admission Bhopal">


<?php $__env->startSection('title', 'About Us'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-5">

    <!-- Page Header -->
    <div class="text-center mb-5">
        <h1 class="fw-bold">Contact Us</h1>
        <p class="text-muted">
            We are happy to assist you with admissions, academic programs, and campus-related enquiries.
            Our team usually responds within <strong>24 working hours</strong>.
        </p>
    </div>

    <!-- Contact Info Cards -->
    <div class="row text-center mb-5 g-4">
        <div class="col-md-4">
            <div class="card h-100 shadow-sm">
                <div class="card-body">
                    <h5 class="card-title">📍 Address</h5>
                    <p class="card-text">
                        Ram Krishna College of Ayurveda & Medical Sciences<br>
                        RKDF University Campus, Bhopal (MP)
                    </p>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card h-100 shadow-sm">
                <div class="card-body">
                    <h5 class="card-title">☎️ Admission Helpline</h5>
                    <p class="card-text">
                        18002700320<br>
                        <small class="text-muted">Mon–Fri | 10:00 AM – 5:00 PM</small>
                    </p>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card h-100 shadow-sm">
                <div class="card-body">
                    <h5 class="card-title">📧 Email</h5>
                    <p class="card-text">
                        admissions@rkcams.in<br>
                        info@rkcams.in
                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- Google Map -->
    <div class="mb-5">
        <iframe src="https://www.google.com/maps?q=RKDF%20University%20Bhopal&output=embed" width="100%" height="350"
            style="border:0;" allowfullscreen loading="lazy">
        </iframe>
        <p class="text-center mt-2">
            <a href="https://maps.google.com?q=RKDF%20University%20Bhopal" target="_blank">
                Open location in Google Maps
            </a>
        </p>
    </div>

    <!-- Contact Form -->
    <div class="row justify-content-center">
        <div class="col-lg-8">

            <div class="card shadow-sm">
                <div class="card-body">
                    <h4 class="mb-4 text-center">Send Us Your Enquiry</h4>

                    <!-- Success Message -->
                    <?php if(session('success')): ?>
                    <div class="alert alert-success">
                        <?php echo e(session('success')); ?>

                    </div>
                    <?php endif; ?>

                    <form method="POST" action="<?php echo e(route('contact.submit')); ?>">
                        <?php echo csrf_field(); ?>

                        <div class="mb-3">
                            <label for="name" class="form-label">Full Name</label>
                            <input type="text" name="name" id="name" class="form-control" required>
                        </div>

                        <div class="mb-3">
                            <label for="email" class="form-label">Email ID</label>
                            <input type="email" name="email" id="email" class="form-control" required>
                        </div>

                        <div class="mb-3">
                            <label for="phone" class="form-label">Mobile Number</label>
                            <input type="text" name="phone" id="phone" class="form-control" required>
                        </div>

                        <div class="mb-3">
                            <label for="message" class="form-label">Your Query</label>
                            <textarea name="message" id="message" rows="4" class="form-control" required></textarea>
                        </div>

                        <!-- reCAPTCHA placeholder -->
                        <!-- <input type="hidden" name="g-recaptcha-response"> -->

                        <div class="text-center">
                            <button type="submit" class="btn btn-primary px-5">
                                Submit Enquiry
                            </button>
                        </div>

                        <p class="text-muted text-center mt-3">
                            Our admission team will contact you within 24 working hours.
                        </p>
                    </form>

                </div>
            </div>

        </div>
    </div>

    <!-- CTA Section -->
    <!-- <div class="text-center mt-5">
        <a href="https://erplive.rkdf.ac.in/Home/OnlineStudent" target="_blank" class="btn btn-outline-success me-2">
            Apply for Admission
        </a>
        <a href="tel:+91XXXXXXXXXX" class="btn btn-outline-primary">
            Call Admission Office
        </a>
    </div> -->
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\RKDF_New_Websites\new_rkcams.in\resources\views/contact-us.blade.php ENDPATH**/ ?>