

<?php $__env->startSection('title', 'Hospital Page - RKCAMS.IN'); ?>

<?php $__env->startSection('content'); ?>
<section class="hospital-section py-5">
    <div class="container">

        <!-- Page Header -->
        <div class="text-center mb-5">
            <h2 class="fw-bold">Ayurvedic Teaching Hospital</h2>
            <p class="text-muted">
                Ram Krishna College of Ayurveda &amp; Medical Sciences, RKDF University – Bhopal
            </p>
        </div>

        <!-- Data of Hospital and College -->
        <div class="card shadow-sm mb-4">
            <div class="card-body">
                <h5 class="card-title fw-bold">Hospital &amp; College Data</h5>

                <ul class="list-group list-group-flush">
                    <li class="list-group-item">Month Wise Teaching Staff Attendance Report: <strong><a href="#"
                                target="_blank">Details </a></strong></li>
                    <li class="list-group-item">Month Wise Non-Teaching Staff Attendance Report: <strong><a href="#"
                                target="_blank">Details </a></strong></li>
                    <li class="list-group-item">Month Wise Hospital Staff Attendance Report: <strong><a href="#"
                                target="_blank">Details </a></strong></li>
                    <li class="list-group-item">Month Wise OPD, IPD And BED Details: <strong><a
                                href="<?php echo e(url('Documents\Ayurveda_Day.pdf')); ?>" target="_blank">Details </a></strong>
                    </li>
                    <li class="list-group-item">Professional Development Program 2023: <strong><a
                                href="<?php echo e(url('Documents\OPD-IPD-BED.pdf')); ?>" target="_blank">Details </a></strong></li>
                    <li class="list-group-item">Facilities: <strong><a href="#" target="_blank">Details </a></strong>
                    </li>
                    <li class="list-group-item">Other Activities: <strong><a href="#" target="_blank">Details
                            </a></strong></li>
                </ul>
            </div>
        </div>

        <!-- About Hospital -->
        <div class="mb-5">
            <h4 class="fw-bold">About the Hospital</h4>
            <p>
                The Ayurvedic Teaching Hospital attached to Ram Krishna College of Ayurveda &amp;
                Medical Sciences provides comprehensive health care services while serving as a
                clinical training center for undergraduate students. The hospital follows
                standards prescribed by NCISM and Ministry of AYUSH.
            </p>
        </div>

        <!-- OPD / IPD Info -->
        <div class="row g-4 mb-5">
            <div class="col-md-6">
                <div class="card h-100 shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Out Patient Department (OPD)</h5>
                        <p>
                            The OPD offers consultation and treatment in various Ayurvedic
                            specialties by qualified faculty and doctors.
                        </p>
                        <ul class="list-unstyled mb-0">
                            <li>✔ Kayachikitsa</li>
                            <li>✔ Panchakarma</li>
                            <li>✔ Shalya Tantra</li>
                            <li>✔ Shalakya Tantra</li>
                            <li>✔ Prasuti &amp; Stri Roga</li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="card h-100 shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">In Patient Department (IPD)</h5>
                        <p>
                            The IPD facility provides round-the-clock patient care with adequate
                            bed strength, nursing staff, and essential services.
                        </p>
                        <ul class="list-unstyled mb-0">
                            <li>✔ Separate male &amp; female wards</li>
                            <li>✔ 24×7 nursing care</li>
                            <li>✔ Daily doctor rounds</li>
                            <li>✔ Hygienic environment</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <!--  -->
        <div class="mb-5">
            <h4 class="fw-bold">Leadership</h4>
            <p>
            <div class="container">
                <ul class="leadership-list" py-2>
                    <li class="py-1"><strong>Principal Details</strong> – <a href="<?php echo e(url('principal')); ?>">Principal Details</a></li>
                    <li class="py-1"><strong>Staff and Departments</strong> – <a
                            href="<?php echo e(url('Documents\Hospital Staff 2025.pdf')); ?>" target="_blank">Hospital Staff and
                            Department</a></li>
                    <li class="py-1"><strong>Clinical Material</strong> – <a href="<?php echo e(url('Documents\Clinical_Material.pdf')); ?>"
                            target="_blank">Clinical Material</a></li>
            </div>
            </p>
        </div>

        <!-- Hospital Facilities -->
        <div class="mb-5">
            <h4 class="fw-bold">Hospital Facilities</h4>
            <div class="row">
                <div class="col-md-4 mb-2">✔ Panchakarma Therapy Unit</div>
                <div class="col-md-4 mb-2">✔ Pathology Laboratory</div>
                <div class="col-md-4 mb-2">✔ Operation Theatre</div>
                <div class="col-md-4 mb-2">✔ Pharmacy (Dispensary)</div>
                <div class="col-md-4 mb-2">✔ Emergency Services</div>
                <div class="col-md-4 mb-2">✔ Yoga &amp; Physiotherapy</div>
            </div>
        </div>

        <!-- Clinical Departments -->
        <div class="mb-5">
            <h4 class="fw-bold">Clinical Departments</h4>
            <div class="table-responsive">
                <table class="table table-bordered align-middle">
                    <thead class="table-light">
                        <tr>
                            <th style="width:10%;">S.No.</th>
                            <th>Department Name</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>1</td>
                            <td><a href="<?php echo e(url('department-Samhita-Siddhanta-Sanskrit')); ?>" target="_self">Samhita Siddhanta & Sanskrit</a>
                            </td>
                        </tr>

                        <tr>
                            <td>2</td>
                            <td><a href="<?php echo e(url('department-Rachana-Sharira')); ?>" target="_self">Rachana Sharira</a>
                            </td>
                        </tr>

                        <tr>
                            <td>3</td>
                            <td><a href="<?php echo e(url('department-Kriya-Sharira')); ?>" target="_self">Kriya Sharira</a>
                            </td>
                        </tr>

                        <tr>
                            <td>4</td>
                            <td><a href="<?php echo e(url('department-Dravyaguna')); ?>" target="_self">Dravyaguna</a>
                            </td>
                        </tr>

                        <tr>
                            <td>5</td>
                            <td><a href="<?php echo e(url('department-Rasashastra-Bhaishajyakalpana')); ?>" target="_self">Rasashastra & Bhaishajyakalpana</a>
                            </td>
                        </tr>

                        <tr>
                            <td>6</td>
                            <td><a href="<?php echo e(url('department-Roga-Nidan-Vikriti-Vigyan')); ?>" target="_self">Roga Nidan & Vikriti Vigyan</a>
                            </td>
                        </tr>

                        <tr>
                            <td>7</td>
                            <td><a href="<?php echo e(url('department-Agada-Tantra')); ?>" target="_self">Agada Tantra</a>
                            </td>
                        </tr>

                        <tr>
                            <td>8</td>
                            <td><a href="<?php echo e(url('department-Swasthavritta-Yoga')); ?>" target="_self">Swasthavritta & Yoga</a>
                            </td>
                        </tr>

                        <tr>
                            <td>9</td>
                            <td><a href="<?php echo e(url('department-Kayachikitsa')); ?>" target="_self">Kayachikitsa</a>
                            </td>
                        </tr>

                        <tr>
                            <td>10</td>
                            <td><a href="<?php echo e(url('department-Panchakarma')); ?>" target="_self">Panchakarma</a>
                            </td>
                        </tr>

                        <tr>
                            <td>11</td>
                            <td><a href="<?php echo e(url('department-Shalya-Tantra')); ?>" target="_self">Shalya Tantra</a>
                            </td>
                        </tr>

                        <tr>
                            <td>12</td>
                            <td><a href="<?php echo e(url('department-Shalakya-Tantra')); ?>" target="_self">Shalakya Tantra</a>
                            </td>
                        </tr>

                        <tr>
                            <td>13</td>
                            <td><a href="<?php echo e(url('department-Prasuti-Tantra-Stree-Roga')); ?>" target="_self">Prasuti Tantra & Stree Roga</a>
                            </td>
                        </tr>

                        <tr>
                            <td>14</td>
                            <td><a href="<?php echo e(url('department-Kaumarabhritya')); ?>" target="_self">Kaumarabhritya</a>
                            </td>
                        </tr>

                    </tbody>
                </table>
            </div>
        </div>

        <!-- Strength -->
        <div class="mb-5">
            <h4 class="fw-bold">Hospital Strength</h4>
            <p class="text-muted">
                The hospital strengthens clinical education by providing hands-on exposure,
                patient interaction, and real-world Ayurvedic practice under expert supervision.
            </p>
        </div>
        <?php if (isset($component)) { $__componentOriginalaf65bb1518abc493659b5a90683fa908 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalaf65bb1518abc493659b5a90683fa908 = $attributes; } ?>
<?php $component = App\View\Components\ImportantLinks::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('ImportantLinks'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\ImportantLinks::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalaf65bb1518abc493659b5a90683fa908)): ?>
<?php $attributes = $__attributesOriginalaf65bb1518abc493659b5a90683fa908; ?>
<?php unset($__attributesOriginalaf65bb1518abc493659b5a90683fa908); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalaf65bb1518abc493659b5a90683fa908)): ?>
<?php $component = $__componentOriginalaf65bb1518abc493659b5a90683fa908; ?>
<?php unset($__componentOriginalaf65bb1518abc493659b5a90683fa908); ?>
<?php endif; ?>
    </div>
</section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\RKDF_New_Websites\new_rkcams.in\resources\views/hospital.blade.php ENDPATH**/ ?>