

<?php $__env->startSection('title', 'Department of Kriya Sharira | Ayurvedic Physiology Department'); ?>

<?php $__env->startSection('meta_description', 'Department of Kriya Sharira (Ayurvedic Physiology) providing foundational education in
    Dosha, Dhatu, Mala, Agni, and body functions with modern physiology labs and practical training for BAMS students.'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Optional: Add your custom styles here -->
    <style>
        /* =========================
            GLOBAL STYLES
            ========================= */

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', 'Open Sans', Arial, sans-serif;
            font-size: 16px;
            line-height: 1.7;
            color: #333;
            background-color: #ffffff;
        }


        ul {
            list-style-image: url('bullet.png');
            /* Path to your bullet image */
            list-style-type: disc;
            /* Fallback if image is not available */
        }

        h1,
        h2,
        h3 {
            font-family: 'Poppins', 'Montserrat', sans-serif;
            color: #1f2a44;
            margin-bottom: 15px;
        }

        h1 {
            font-size: 36px;
        }

        h2 {
            font-size: 28px;
        }

        p {
            margin-bottom: 15px;
        }

        a {
            text-decoration: none;
            color: #1a4ed8;
        }

        a:hover {
            text-decoration: underline;
        }

        /* =========================
                                                        LAYOUT
                                                        ========================= */

        .container {
            max-width: 1100px;
            margin: auto;
            padding: 0 20px;
        }

        .section {
            padding: 60px 0;
        }

        .bg-light {
            background-color: #f7f9fc;
        }

        .bg-primary {
            background-color: #1f2a44;
        }

        /* =========================
                                                        HERO SECTION
                                                        ========================= */

        .hero-section {
            background: linear-gradient(rgba(31, 42, 68, 0.7),
                    rgba(31, 42, 68, 0.7)),
                url('campus-photo.jpg') center/cover no-repeat;
            text-align: center;
            padding: 100px 20px;
            color: #ffffff;
        }

        .hero-section h1 {
            color: #ffffff;
            font-size: 42px;
        }

        .hero-section p {
            font-size: 18px;
            margin-bottom: 30px;
        }

        /* =========================
                                                        BUTTONS
                                                        ========================= */

        .btn {
            display: inline-block;
            padding: 12px 26px;
            margin: 5px;
            border-radius: 6px;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .btn.primary {
            background-color: #f0b429;
            color: #1f2a44;
        }

        .btn.primary:hover {
            background-color: #d99b1f;
        }

        .btn.secondary {
            background-color: transparent;
            border: 2px solid #ffffff;
            color: #ffffff;
        }

        .btn.secondary:hover {
            background-color: #ffffff;
            color: #1f2a44;
        }

        /* =========================
                                                        LISTS & CONTENT
                                                        ========================= */

        .strength-list,
        .leadership-list,
        .important-links {
            list-style: none;
            padding-left: 0;
        }

        .strength-list li,
        .leadership-list li {
            padding: 10px 0;
            padding-left: 28px;
            position: relative;
        }

        .strength-list li::before {
            content: "✔";
            position: absolute;
            left: 0;
            color: #1a4ed8;
            font-weight: bold;
        }

        /* =========================
                                                        FACILITIES GRID
                                                        ========================= */

        .facility-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
            gap: 20px;
            margin-top: 30px;
        }

        .facility-item {
            background: #c9c7bf;
            padding: 25px;
            text-align: center;
            border-radius: 10px;
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.08);
            font-weight: 600;
        }

        /* =========================
                                                        LINKS SECTION
                                                        ========================= */

        .important-links li {
            margin-bottom: 10px;
        }

        .important-links a {
            color: #ffffff;
            font-weight: 500;
        }

        .section {
            padding: 30px 0;
        }

        /* =========================
                                                        FOOTER
                                                        ========================= */

        .footer {
            background-color: #f1f3f6;
            text-align: center;
            font-size: 14px;
            color: #666;
        }

        .footer p {
            margin: 0;
        }

        /* =========================
                                                        RESPONSIVE DESIGN
                                                        ========================= */

        @media (max-width: 768px) {
            h1 {
                font-size: 30px;
            }

            h2 {
                font-size: 24px;
            }

            .hero-section {
                padding: 70px 20px;
            }

            .btn {
                width: 100%;
                max-width: 280px;
            }
        }
    </style>
    <div class="container my-5">

        <!-- ================= PAGE HEADER ================= -->
        <header class="text-center mb-5">
            <h1 class="fw-bold">Department of Kriya Sharira</h1>
            <p class="text-muted">
                Ayurvedic Physiology • Functional Biology • Dosha–Dhatu–Mala Siddhanta • Body Functions & Homeostasis
            </p>
        </header>


        <!-- ================= Department Overview ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Department Overview</h2>

            <p class="text-justify">
                The Department of Kriya Sharira focuses on the functional aspects of the human body,
                integrating classical Ayurvedic physiology with modern biomedical sciences.
                Students develop a deep understanding of Dosha, Dhatu, Mala, Agni, Prana,
                and homeostatic mechanisms that govern health and disease. The department
                serves as the physiological foundation for all clinical and therapeutic disciplines in Ayurveda.
            </p>

            <ul>
                <li>Study of body functions and biological systems</li>
                <li>Conceptual understanding of Dosha–Dhatu–Mala theory</li>
                <li>Correlation of Ayurvedic and modern physiology</li>
                <li>Practical experiments and clinical relevance</li>
            </ul>
        </section>


        <!-- ================= Vision & Mission ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Vision & Mission</h2>

            <div class="row g-4">

                <div class="col-md-6">
                    <div class="card shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-semibold">Vision</h5>
                            <p>
                                To cultivate excellence in Ayurvedic physiological sciences by blending
                                traditional wisdom with scientific learning for competent healthcare practice.
                            </p>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="card shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-semibold">Mission</h5>
                            <ul>
                                <li>Deliver strong conceptual foundations in physiology</li>
                                <li>Encourage practical laboratory-based training</li>
                                <li>Promote research in functional biology</li>
                                <li>Prepare students for clinical application of principles</li>
                            </ul>
                        </div>
                    </div>
                </div>

            </div>
        </section>


        <!-- ================= Courses ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Courses & Teaching Programs</h2>

            <div class="table-responsive">
                <table class="table table-bordered table-striped align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>Program</th>
                            <th>Year</th>
                            <th>Subject</th>
                            <th>Component</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>BAMS</td>
                            <td>1st Professional</td>
                            <td>Kriya Sharira</td>
                            <td>Theory + Practical</td>
                        </tr>
                        <tr>
                            <td>BAMS</td>
                            <td>1st Professional</td>
                            <td>Experimental Physiology</td>
                            <td>Lab Based</td>
                        </tr>
                        <tr>
                            <td>Workshops</td>
                            <td>Advanced</td>
                            <td>Clinical Physiology Applications</td>
                            <td>Demonstration</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </section>


        <!-- ================= Faculty ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Faculty & Staff</h2>

            <div class="row g-4">

                <div class="col-md-4">
                    <div class="card text-center shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-bold">Dr. R. Mehta</h5>
                            <p class="text-muted mb-1">Professor & Head</p>
                            <small>MD (Kriya Sharira) | 18+ Years Experience</small>
                        </div>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="card text-center shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-bold">Dr. S. Iyer</h5>
                            <p class="text-muted mb-1">Assistant Professor</p>
                            <small>Physiology & Functional Studies Specialist</small>
                        </div>
                    </div>
                </div>

            </div>
        </section>


        <!-- ================= Infrastructure ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Infrastructure & Facilities</h2>

            <div class="row row-cols-1 row-cols-md-2 g-2">
                <div class="col">✔ Physiology Laboratory</div>
                <div class="col">✔ Clinical Examination Equipment</div>
                <div class="col">✔ Digital Simulation Models</div>
                <div class="col">✔ Hematology & Biochemistry Instruments</div>
                <div class="col">✔ Demonstration Hall</div>
                <div class="col">✔ Smart Classroom with AV Tools</div>
            </div>
        </section>


        <!-- ================= Teaching Methodology ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Teaching Methodology</h2>

            <ul>
                <li>Concept-based lectures with clinical correlation</li>
                <li>Laboratory experiments & physiological testing</li>
                <li>Interactive tutorials & seminars</li>
                <li>Case studies and applied learning</li>
                <li>Digital teaching aids & demonstrations</li>
            </ul>
        </section>


        <!-- ================= Research ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Research & Publications</h2>

            <ul>
                <li>Studies on Dosha physiology and functional mechanisms</li>
                <li>Clinical physiology research projects</li>
                <li>Peer-reviewed journal publications</li>
                <li>Conference papers & academic presentations</li>
            </ul>
        </section>


        <!-- ================= Activities ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Academic & Co-Curricular Activities</h2>

            <ul>
                <li>Physiology workshops</li>
                <li>Student seminars & demonstrations</li>
                <li>Guest lectures by medical experts</li>
                <li>Scientific exhibitions & awareness programs</li>
            </ul>
        </section>


        <!-- ================= Student Support ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Student Support</h2>

            <ul>
                <li>Lab manuals & learning resources</li>
                <li>Mentoring & academic counseling</li>
                <li>Continuous assessments & feedback</li>
                <li>Practical skill development sessions</li>
            </ul>
        </section>


        <!-- ================= Gallery ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Photo & Media Gallery</h2>

            <div class="row g-3">
                <div class="col-md-3">
                    <img src="/images/kriya1.jpg" class="img-fluid rounded" alt="Physiology Lab">
                </div>
                <div class="col-md-3">
                    <img src="/images/kriya2.jpg" class="img-fluid rounded" alt="Practical Demonstration">
                </div>
                <div class="col-md-3">
                    <img src="/images/kriya3.jpg" class="img-fluid rounded" alt="Student Training Session">
                </div>
                <div class="col-md-3">
                    <img src="/images/kriya4.jpg" class="img-fluid rounded" alt="Laboratory Equipment">
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>




<?php $__env->startSection('title', 'Department of Kriya Sharira | Ayurvedic Physiology Department'); ?>

<?php $__env->startSection('meta_description', 'Department of Kriya Sharira (Ayurvedic Physiology) providing foundational education in
    Dosha, Dhatu, Mala, Agni, and body functions with modern physiology labs and practical training for BAMS students.'); ?>

<?php $__env->startSection('content'); ?>

    <div class="container my-5">

        <!-- ================= PAGE HEADER ================= -->
        <header class="text-center mb-5">
            <h1 class="fw-bold">Department of Kriya Sharira</h1>
            <p class="text-muted">
                Ayurvedic Physiology • Functional Biology • Dosha–Dhatu–Mala Siddhanta • Body Functions & Homeostasis
            </p>
        </header>


        <!-- ================= Department Overview ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Department Overview</h2>

            <p>
                The Department of Kriya Sharira focuses on the functional aspects of the human body,
                integrating classical Ayurvedic physiology with modern biomedical sciences.
                Students develop a deep understanding of Dosha, Dhatu, Mala, Agni, Prana,
                and homeostatic mechanisms that govern health and disease. The department
                serves as the physiological foundation for all clinical and therapeutic disciplines in Ayurveda.
            </p>

            <ul>
                <li>Study of body functions and biological systems</li>
                <li>Conceptual understanding of Dosha–Dhatu–Mala theory</li>
                <li>Correlation of Ayurvedic and modern physiology</li>
                <li>Practical experiments and clinical relevance</li>
            </ul>
        </section>


        <!-- ================= Vision & Mission ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Vision & Mission</h2>

            <div class="row g-4">

                <div class="col-md-6">
                    <div class="card shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-semibold">Vision</h5>
                            <p>
                                To cultivate excellence in Ayurvedic physiological sciences by blending
                                traditional wisdom with scientific learning for competent healthcare practice.
                            </p>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="card shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-semibold">Mission</h5>
                            <ul>
                                <li>Deliver strong conceptual foundations in physiology</li>
                                <li>Encourage practical laboratory-based training</li>
                                <li>Promote research in functional biology</li>
                                <li>Prepare students for clinical application of principles</li>
                            </ul>
                        </div>
                    </div>
                </div>

            </div>
        </section>


        <!-- ================= Courses ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Courses & Teaching Programs</h2>

            <div class="table-responsive">
                <table class="table table-bordered table-striped align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>Program</th>
                            <th>Year</th>
                            <th>Subject</th>
                            <th>Component</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>BAMS</td>
                            <td>1st Professional</td>
                            <td>Kriya Sharira</td>
                            <td>Theory + Practical</td>
                        </tr>
                        <tr>
                            <td>BAMS</td>
                            <td>1st Professional</td>
                            <td>Experimental Physiology</td>
                            <td>Lab Based</td>
                        </tr>
                        <tr>
                            <td>Workshops</td>
                            <td>Advanced</td>
                            <td>Clinical Physiology Applications</td>
                            <td>Demonstration</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </section>


        <!-- ================= Faculty ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Faculty & Staff</h2>

            <div class="row g-4">

                <div class="col-md-4">
                    <div class="card text-center shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-bold">Dr. R. Mehta</h5>
                            <p class="text-muted mb-1">Professor & Head</p>
                            <small>MD (Kriya Sharira) | 18+ Years Experience</small>
                        </div>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="card text-center shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-bold">Dr. S. Iyer</h5>
                            <p class="text-muted mb-1">Assistant Professor</p>
                            <small>Physiology & Functional Studies Specialist</small>
                        </div>
                    </div>
                </div>

            </div>
        </section>


        <!-- ================= Infrastructure ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Infrastructure & Facilities</h2>

            <div class="row row-cols-1 row-cols-md-2 g-2">
                <div class="col">✔ Physiology Laboratory</div>
                <div class="col">✔ Clinical Examination Equipment</div>
                <div class="col">✔ Digital Simulation Models</div>
                <div class="col">✔ Hematology & Biochemistry Instruments</div>
                <div class="col">✔ Demonstration Hall</div>
                <div class="col">✔ Smart Classroom with AV Tools</div>
            </div>
        </section>


        <!-- ================= Teaching Methodology ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Teaching Methodology</h2>

            <ul>
                <li>Concept-based lectures with clinical correlation</li>
                <li>Laboratory experiments & physiological testing</li>
                <li>Interactive tutorials & seminars</li>
                <li>Case studies and applied learning</li>
                <li>Digital teaching aids & demonstrations</li>
            </ul>
        </section>


        <!-- ================= Research ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Research & Publications</h2>

            <ul>
                <li>Studies on Dosha physiology and functional mechanisms</li>
                <li>Clinical physiology research projects</li>
                <li>Peer-reviewed journal publications</li>
                <li>Conference papers & academic presentations</li>
            </ul>
        </section>


        <!-- ================= Activities ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Academic & Co-Curricular Activities</h2>

            <ul>
                <li>Physiology workshops</li>
                <li>Student seminars & demonstrations</li>
                <li>Guest lectures by medical experts</li>
                <li>Scientific exhibitions & awareness programs</li>
            </ul>
        </section>


        <!-- ================= Student Support ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Student Support</h2>

            <ul>
                <li>Lab manuals & learning resources</li>
                <li>Mentoring & academic counseling</li>
                <li>Continuous assessments & feedback</li>
                <li>Practical skill development sessions</li>
            </ul>
        </section>


        <!-- ================= Gallery ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Photo & Media Gallery</h2>

            <div class="row g-3">
                <div class="col-md-3">
                    <img src="/images/kriya1.jpg" class="img-fluid rounded" alt="Physiology Lab">
                </div>
                <div class="col-md-3">
                    <img src="/images/kriya2.jpg" class="img-fluid rounded" alt="Practical Demonstration">
                </div>
                <div class="col-md-3">
                    <img src="/images/kriya3.jpg" class="img-fluid rounded" alt="Student Training Session">
                </div>
                <div class="col-md-3">
                    <img src="/images/kriya4.jpg" class="img-fluid rounded" alt="Laboratory Equipment">
                </div>
            </div>
        </section>

    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\RKDF_New_Websites\new_rkcams.in\resources\views/Kriya-Sharira.blade.php ENDPATH**/ ?>