

<?php $__env->startSection('title', 'Department of Shalakya Tantra | Ayurvedic Ophthalmology, ENT and Dental Sciences'); ?>
<?php $__env->startSection('meta_description', 'Department of Shalakya Tantra offering Ayurvedic eye care, ENT treatments, dental
    procedures, minor surgeries, and clinical training with OPD/IPD facilities and modern diagnostic support for students
    and patients.'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Optional: Add your custom styles here -->
    <style>
        /* =========================
            GLOBAL STYLES
            ========================= */

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', 'Open Sans', Arial, sans-serif;
            font-size: 16px;
            line-height: 1.7;
            color: #333;
            background-color: #ffffff;
        }


        ul {
            list-style-image: url('bullet.png');
            /* Path to your bullet image */
            list-style-type: disc;
            /* Fallback if image is not available */
        }

        h1,
        h2,
        h3 {
            font-family: 'Poppins', 'Montserrat', sans-serif;
            color: #1f2a44;
            margin-bottom: 15px;
        }

        h1 {
            font-size: 36px;
        }

        h2 {
            font-size: 28px;
        }

        p {
            margin-bottom: 15px;
        }

        a {
            text-decoration: none;
            color: #1a4ed8;
        }

        a:hover {
            text-decoration: underline;
        }

        /* =========================
                                                        LAYOUT
                                                        ========================= */

        .container {
            max-width: 1100px;
            margin: auto;
            padding: 0 20px;
        }

        .section {
            padding: 60px 0;
        }

        .bg-light {
            background-color: #f7f9fc;
        }

        .bg-primary {
            background-color: #1f2a44;
        }

        /* =========================
                                                        HERO SECTION
                                                        ========================= */

        .hero-section {
            background: linear-gradient(rgba(31, 42, 68, 0.7),
                    rgba(31, 42, 68, 0.7)),
                url('campus-photo.jpg') center/cover no-repeat;
            text-align: center;
            padding: 100px 20px;
            color: #ffffff;
        }

        .hero-section h1 {
            color: #ffffff;
            font-size: 42px;
        }

        .hero-section p {
            font-size: 18px;
            margin-bottom: 30px;
        }

        /* =========================
                                                        BUTTONS
                                                        ========================= */

        .btn {
            display: inline-block;
            padding: 12px 26px;
            margin: 5px;
            border-radius: 6px;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .btn.primary {
            background-color: #f0b429;
            color: #1f2a44;
        }

        .btn.primary:hover {
            background-color: #d99b1f;
        }

        .btn.secondary {
            background-color: transparent;
            border: 2px solid #ffffff;
            color: #ffffff;
        }

        .btn.secondary:hover {
            background-color: #ffffff;
            color: #1f2a44;
        }

        /* =========================
                                                        LISTS & CONTENT
                                                        ========================= */

        .strength-list,
        .leadership-list,
        .important-links {
            list-style: none;
            padding-left: 0;
        }

        .strength-list li,
        .leadership-list li {
            padding: 10px 0;
            padding-left: 28px;
            position: relative;
        }

        .strength-list li::before {
            content: "✔";
            position: absolute;
            left: 0;
            color: #1a4ed8;
            font-weight: bold;
        }

        /* =========================
                                                        FACILITIES GRID
                                                        ========================= */

        .facility-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
            gap: 20px;
            margin-top: 30px;
        }

        .facility-item {
            background: #c9c7bf;
            padding: 25px;
            text-align: center;
            border-radius: 10px;
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.08);
            font-weight: 600;
        }

        /* =========================
                                                        LINKS SECTION
                                                        ========================= */

        .important-links li {
            margin-bottom: 10px;
        }

        .important-links a {
            color: #ffffff;
            font-weight: 500;
        }

        .section {
            padding: 30px 0;
        }

        /* =========================
                                                        FOOTER
                                                        ========================= */

        .footer {
            background-color: #f1f3f6;
            text-align: center;
            font-size: 14px;
            color: #666;
        }

        .footer p {
            margin: 0;
        }

        /* =========================
                                                        RESPONSIVE DESIGN
                                                        ========================= */

        @media (max-width: 768px) {
            h1 {
                font-size: 30px;
            }

            h2 {
                font-size: 24px;
            }

            .hero-section {
                padding: 70px 20px;
            }

            .btn {
                width: 100%;
                max-width: 280px;
            }
        }
    </style>
    <div class="container my-5">

        <!-- ================= PAGE HEADER ================= -->
        <header class="text-center mb-5">
            <h1 class="fw-bold">Department of Shalakya Tantra</h1>
            <p class="text-muted">
                Ayurvedic Ophthalmology • ENT Care • Dental Sciences • Head & Neck Therapeutics
            </p>
        </header>


        <!-- ================= Department Overview ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Department Overview</h2>

            <p class="text-justify">
                The Department of Shalakya Tantra deals with the diagnosis, treatment, and surgical
                management of diseases affecting the eye, ear, nose, throat, oral cavity, and head region.
                Rooted in classical Ayurvedic texts, the department integrates traditional therapies with
                modern diagnostic tools to provide comprehensive ENT and ophthalmic care. Students
                receive structured clinical exposure through outpatient and inpatient services, minor
                procedures, and specialized therapeutic interventions.
            </p>

            <ul>
                <li>Management of eye disorders and visual health</li>
                <li>ENT and upper respiratory tract treatments</li>
                <li>Dental and oral healthcare procedures</li>
                <li>Clinical training in head & neck therapeutics</li>
            </ul>
        </section>


        <!-- ================= Vision & Mission ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Vision & Mission</h2>

            <div class="row g-4">

                <div class="col-md-6">
                    <div class="card shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-semibold">Vision</h5>
                            <p>
                                To achieve excellence in Ayurvedic ophthalmology and ENT sciences through
                                advanced clinical education, compassionate patient care, and research innovation.
                            </p>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="card shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-semibold">Mission</h5>
                            <ul>
                                <li>Provide specialized head & neck healthcare services</li>
                                <li>Enhance hands-on procedural training</li>
                                <li>Promote evidence-based Ayurvedic therapies</li>
                                <li>Encourage clinical research and skill development</li>
                            </ul>
                        </div>
                    </div>
                </div>

            </div>
        </section>


        <!-- ================= Courses ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Courses & Teaching Programs</h2>

            <div class="table-responsive">
                <table class="table table-bordered table-striped align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>Program</th>
                            <th>Year</th>
                            <th>Subject</th>
                            <th>Component</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>BAMS</td>
                            <td>Final Professional</td>
                            <td>Shalakya Tantra</td>
                            <td>Theory + Clinical Practice</td>
                        </tr>
                        <tr>
                            <td>Internship</td>
                            <td>Clinical Posting</td>
                            <td>ENT & Ophthalmic Training</td>
                            <td>OPD/IPD Exposure</td>
                        </tr>
                        <tr>
                            <td>Skill Workshops</td>
                            <td>Advanced</td>
                            <td>Minor Surgical Procedures</td>
                            <td>Hands-on</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </section>


        <!-- ================= Faculty ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Faculty & Staff</h2>

            <div class="row g-4">

                <div class="col-md-4">
                    <div class="card text-center shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-bold">Dr. N. Desai</h5>
                            <p class="text-muted mb-1">Professor & Head</p>
                            <small>MS (Shalakya Tantra) | Ophthalmology Specialist</small>
                        </div>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="card text-center shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-bold">Dr. P. Iqbal</h5>
                            <p class="text-muted mb-1">Assistant Professor</p>
                            <small>ENT & Dental Care Expert</small>
                        </div>
                    </div>
                </div>

            </div>
        </section>


        <!-- ================= Infrastructure ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Infrastructure & Facilities</h2>

            <div class="row row-cols-1 row-cols-md-2 g-2">
                <div class="col">✔ Dedicated ENT & Eye OPD Rooms</div>
                <div class="col">✔ Minor Operation Theatre</div>
                <div class="col">✔ Ophthalmic Diagnostic Equipment</div>
                <div class="col">✔ Audiometry & ENT Instruments</div>
                <div class="col">✔ Dental Chair & Procedure Unit</div>
                <div class="col">✔ Inpatient Ward with Recovery Beds</div>
            </div>
        </section>


        <!-- ================= Teaching Methodology ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Teaching Methodology</h2>

            <ul>
                <li>Live clinical demonstrations</li>
                <li>Hands-on minor surgical training</li>
                <li>Case-based discussions & diagnosis practice</li>
                <li>Ward rounds and patient evaluation</li>
                <li>Interactive seminars and practical workshops</li>
            </ul>
        </section>


        <!-- ================= Research ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Research & Publications</h2>

            <ul>
                <li>Clinical studies on ocular and ENT disorders</li>
                <li>Standardization of Ayurvedic therapies</li>
                <li>Comparative outcome research</li>
                <li>Publications in peer-reviewed journals</li>
            </ul>
        </section>


        <!-- ================= Activities ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Academic & Co-Curricular Activities</h2>

            <ul>
                <li>Eye screening and ENT health camps</li>
                <li>Skill enhancement workshops</li>
                <li>Awareness programs for community health</li>
                <li>Guest lectures by specialists</li>
            </ul>
        </section>


        <!-- ================= Student Support ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Student Support</h2>

            <ul>
                <li>Clinical manuals and procedural guides</li>
                <li>Hands-on mentorship & supervision</li>
                <li>Case documentation support</li>
                <li>Research and career counseling</li>
            </ul>
        </section>


        <!-- ================= Gallery ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Photo & Media Gallery</h2>

            <div class="row g-3">
                <div class="col-md-3">
                    <img src="/images/shalakya1.jpg" class="img-fluid rounded" alt="Eye Examination Room">
                </div>
                <div class="col-md-3">
                    <img src="/images/shalakya2.jpg" class="img-fluid rounded" alt="ENT Procedure">
                </div>
                <div class="col-md-3">
                    <img src="/images/shalakya3.jpg" class="img-fluid rounded" alt="Dental Unit">
                </div>
                <div class="col-md-3">
                    <img src="/images/shalakya4.jpg" class="img-fluid rounded" alt="Clinical Teaching Session">
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\RKDF_New_Websites\new_rkcams.in\resources\views/Shalakya-Tantra.blade.php ENDPATH**/ ?>