@extends('layouts.app')

@section('title', 'Home Page - RKCAMS.IN')

@section('content')
<section class="courses-info py-5">
    <div class="container">

        <!-- Section Header -->
        <div class="text-center mb-4">
            <h2 class="fw-bold">Course, Intake & Fees</h2>
            <p class="text-muted">Ram Krishna College of Ayurveda &amp; Medical Sciences, RKDF University – Bhopal</p>
        </div>

        <!-- Course Details Card -->
        <div class="card shadow-sm mb-4">
            <div class="card-body">
                <h4 class="card-title">Bachelor of Ayurvedic Medicine and Surgery (B.A.M.S.)</h4>

                <!-- Course Summary -->
                <div class="row mt-3">
                    <!-- Duration -->
                    <div class="col-md-6 mb-3">
                        <h6 class="text-uppercase text-secondary"><strong>Duration</strong></h6>
                        <p>4.5 Years + 1 Year Internship</p>
                    </div>

                    <!-- Intake -->
                    <div class="col-md-6 mb-3">
                        <h6 class="text-uppercase text-secondary"><strong>Intake</strong></h6>
                        <p>100 Seats (2023–24 Session)</p>
                    </div>

                    <!-- Eligibility -->
                    <div class="col-md-6 mb-3">
                        <h6 class="text-uppercase text-secondary"><strong>Eligibility</strong></h6>
                        <p>
                            Passed 10+2 or equivalent with Physics, Chemistry &amp; Biology (PCB) and English,
                            with at least 50% marks; minimum age 17 years. Admission through NEET Counseling
                            conducted by MP AYUSH &amp; Ministry of AYUSH (15% All India Quota).
                        </p>
                    </div>

                    <!-- Fees -->
                    <div class="col-md-6 mb-3">
                        <h6 class="text-uppercase text-secondary"><strong>Fees</strong></h6>
                        <p><strong>₹2,64,300 per year (approx).</strong></p>
                    </div>
                </div>

                <!-- Course Overview -->
                <div class="mt-4">
                    <h6 class="fw-semibold"><strong>Overview</strong></h6>
                    <p class="text-muted">
                        The Bachelor of Ayurvedic Medicine and Surgery (B.A.M.S.) is an undergraduate degree
                        integrating modern medical principles with traditional Ayurveda. The course spans
                        5.5 years including a compulsory internship. Upon successful completion and
                        principal’s recommendation, the university awards the degree.
                    </p>
                </div>
            </div>
        </div>

        <!-- Strength Section -->
        <div class="mb-4">
            <h4 class="fw-bold">Our Strength</h4>
            <p class="text-muted">
                The institute boasts strong administration and visionaries that cultivate discipline
                and professionalism.
            </p>
        </div>

        <!-- Important Links -->
        <div class="mb-5">
            <h4 class="fw-bold">Important Links</h4>
            <ul class="list-group list-group-flush">
                <li class="list-group-item">
                    <a href="https://rkdf.ac.in" target="_blank">RKDF University</a>
                </li>
                <li class="list-group-item">
                    <a href="https://ncismindia.org" target="_blank">National Commission for Indian System of Medicine
                        (NCISM)</a>
                </li>
                <li class="list-group-item">
                    <a href="https://www.ayush.gov.in" target="_blank">Ministry of AYUSH</a>
                </li>
            </ul>
        </div>

        <!-- Facilities List -->
        <div class="mb-4">
            <h4 class="fw-bold">Facilities</h4>
            <div class="row">
                <div class="col-md-4 mb-2">Sports &amp; Other Activities</div>
                <div class="col-md-4 mb-2">Canteen</div>
                <div class="col-md-4 mb-2">Hostel</div>
                <div class="col-md-4 mb-2">Wi-Fi Campus</div>
                <div class="col-md-4 mb-2">Transport Facility</div>
            </div>
        </div>
    </div>
</section>
@endsection