@extends('layouts.app')

@section('title', 'Institute Page - RKCAMS.IN')

@section('content')
    <!-- Optional: Add your custom styles here -->
    <style>
        /* =========================
                                                    GLOBAL STYLES
                                                    ========================= */

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', 'Open Sans', Arial, sans-serif;
            font-size: 16px;
            line-height: 1.7;
            color: #333;
            background-color: #ffffff;
        }


        ul {
            list-style-image: url('bullet.png');
            /* Path to your bullet image */
            list-style-type: disc;
            /* Fallback if image is not available */
        }

        h1,
        h2,
        h3 {
            font-family: 'Poppins', 'Montserrat', sans-serif;
            color: #1f2a44;
            margin-bottom: 15px;
        }

        h1 {
            font-size: 36px;
        }

        h2 {
            font-size: 28px;
        }

        p {
            margin-bottom: 15px;
        }

        a {
            text-decoration: none;
            color: #1a4ed8;
        }

        a:hover {
            text-decoration: underline;
        }

        /* =========================
                                                    LAYOUT
                                                    ========================= */

        .container {
            max-width: 1100px;
            margin: auto;
            padding: 0 20px;
        }

        .section {
            padding: 60px 0;
        }

        .bg-light {
            background-color: #f7f9fc;
        }

        .bg-primary {
            background-color: #1f2a44;
        }

        /* =========================
                                                    HERO SECTION
                                                    ========================= */

        .hero-section {
            background: linear-gradient(rgba(31, 42, 68, 0.7),
                    rgba(31, 42, 68, 0.7)),
                url('campus-photo.jpg') center/cover no-repeat;
            text-align: center;
            padding: 100px 20px;
            color: #ffffff;
        }

        .hero-section h1 {
            color: #ffffff;
            font-size: 42px;
        }

        .hero-section p {
            font-size: 18px;
            margin-bottom: 30px;
        }

        /* =========================
                                                    BUTTONS
                                                    ========================= */

        .btn {
            display: inline-block;
            padding: 12px 26px;
            margin: 5px;
            border-radius: 6px;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .btn.primary {
            background-color: #f0b429;
            color: #1f2a44;
        }

        .btn.primary:hover {
            background-color: #d99b1f;
        }

        .btn.secondary {
            background-color: transparent;
            border: 2px solid #ffffff;
            color: #ffffff;
        }

        .btn.secondary:hover {
            background-color: #ffffff;
            color: #1f2a44;
        }

        /* =========================
                                                    LISTS & CONTENT
                                                    ========================= */

        .strength-list,
        .leadership-list,
        .important-links {
            list-style: none;
            padding-left: 0;
        }

        .strength-list li,
        .leadership-list li {
            padding: 10px 0;
            padding-left: 28px;
            position: relative;
        }

        .strength-list li::before {
            content: "✔";
            position: absolute;
            left: 0;
            color: #1a4ed8;
            font-weight: bold;
        }

        /* =========================
                                                    FACILITIES GRID
                                                    ========================= */

        .facility-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
            gap: 20px;
            margin-top: 30px;
        }

        .facility-item {
            background: #c9c7bf;
            padding: 25px;
            text-align: center;
            border-radius: 10px;
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.08);
            font-weight: 600;
        }

        /* =========================
                                                    LINKS SECTION
                                                    ========================= */

        .important-links li {
            margin-bottom: 10px;
        }

        .important-links a {
            color: #ffffff;
            font-weight: 500;
        }

        .section {
            padding: 30px 0;
        }

        /* =========================
                                                    FOOTER
                                                    ========================= */

        .footer {
            background-color: #f1f3f6;
            text-align: center;
            font-size: 14px;
            color: #666;
        }

        .footer p {
            margin: 0;
        }

        /* =========================
                                                    RESPONSIVE DESIGN
                                                    ========================= */

        @media (max-width: 768px) {
            h1 {
                font-size: 30px;
            }

            h2 {
                font-size: 24px;
            }

            .hero-section {
                padding: 70px 20px;
            }

            .btn {
                width: 100%;
                max-width: 280px;
            }
        }
    </style>

        <!-- Institutional Information -->
        <div class="card shadow-sm mb-4">
            <div class="card-body">
                <h5 class="card-title fw-bold">Institutional Information</h5>

                <div class="table-responsive">
                    <table class="table table-bordered align-middle mb-0">
                        <tbody>
                            <tr>
                                <th style="width:35%;">Name of the Institution</th>
                                <td>Ram Krishna College of Ayurveda &amp; Medical Sciences</td>
                            </tr>
                            <tr>
                                <th>University Affiliation</th>
                                <td>RKDF University, Bhopal</td>
                            </tr>
                            <tr>
                                <th>Location</th>
                                <td>Gandhi Nagar, Airport Bypass Road, Bhopal (M.P)</td>
                            </tr>
                            <tr>
                                <th>Approval / Recognition</th>
                                <td>Ministry of AYUSH &amp; NCISM</td>
                            </tr>
                            <tr>
                                <th>Type of Institution</th>
                                <td>Private Ayurvedic College</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    <!-- About the College -->
    <section id="College" class="section">
        <div class="container pt-4">
            <h2>About the Institute</h2>
            <p>Ram Krishna College of Ayurveda & Medical Sciences (RKCAMS) is a distinguished institution located in Gandhi
                Nagar,
                Bhopal,
                offering academic excellence and professional Ayurveda training under RKDF University.</p>
            <p>The institute focuses on strong administration,
                discipline,
                and a vision-driven learning environment that nurtures future healthcare professionals.</p>
        </div>
    </section>

    <!-- Our Strengths -->
    <section class="section bg-light">
        <div class="container">
            <h2>Our Strengths</h2>
            <ul class="strength-list">
                <li>Strong Administration & Vision</li>
                <li>Well-Equipped Facilities</li>
                <li>Experienced Academic Staff</li>
                <li>Focus on Discipline & Professionalism</li>
            </ul>
        </div>
    </section>


    <!-- ===================================================== -->
    <!-- Regulatory Approvals -->
    <!-- ===================================================== -->

    <section id="facilities" class="section">
        <div class="container">
            <h2>Regulatory Approvals</h2>
            <div class="card mb-4 shadow-sm">
                <!--                <div class="card-header text-black fw-bold">
                                                        Regulatory Approvals
                                                    </div>
                                    -->
                <div class="card-body">
                    <div class="row">
                        <!-- ================= Registrations ================= -->
                        <div class="col-md-12 mb-4">
                            <h5 class="text-primary fw-bold">Registrations</h5>

                            <ul class="ps-3">
                                <li>
                                    NCISM College Registration – Ref No: REG/2024/001 – Valid till 2027
                                </li>
                                <li>
                                    Hospital Registration – Ref No: HOSP/2024/010 – Valid till 2026
                                </li>
                            </ul>
                            <hr>
                        </div>


                        <!-- ================= Permissions ================= -->
                        <div class="col-md-12 mb-4">
                            <h5 class="text-success fw-bold">Permissions</h5>

                            <ul class="ps-3">
                                <li>
                                    Intake Capacity Permission – 100 Students – 2024–25
                                </li>
                                <li>
                                    PG Course Permission – Panchakarma – 2024
                                </li>
                            </ul>
                            <hr>
                        </div>

                        <!-- ================= Approvals ================= -->
                        <div class="col-md-12 mb-4">
                            <div class="col-md-12 mb-4">
                                <h5 class="text-warning fw-bold">Approvals</h5>

                                <h5 class="text-warning fw-bold">Government of India Approval – AYUSH Ministry</h5>
                                <ul class="ps-3">
                                    <li><a href="{{ url('Documents\NCSIM_Permission\LOP-BAMS_YEAR_2025-2026.pdf') }}"
                                            target="_blank">Letter of Permission(LOP) 2025-26</a></li>
                                    <li><a href="{{ url('Documents\NCSIM_Permission\LOP-BAMS_YEAR_2024-2025.pdf') }}"
                                            target="_blank">Letter of Permission(LOP) 2024-25</a></li>
                                    <li><a href="{{ url('Documents\NCSIM_Permission\LOP-BAMS 2023-24.pdf') }}"
                                            target="_blank">Letter of Permission(LOP) 2023-24</a></li>
                                    <li><a href="{{ url('Documents\NCSIM_Permission\LOP-BAMS 2022-23.pdf') }}"
                                            target="_blank">Letter of Permission(LOP) 2022-23</a></li>
                                </ul>

                                <h5 class="text-warning fw-bold">State Health Department Approval – Clinical Operations</h5>
                                <ul class="ps-3">
                                    <li></li>
                                    <li></li>
                                </ul>
                                <hr>
                            </div>


                            <!-- ================= Affiliations ================= -->
                            <div class="col-md-12 mb-4">
                                <h5 class="text-info fw-bold">Affiliations</h5>

                                <ul class="ps-3">
                                    <li>
                                        Affiliated to XYZ University – BAMS Program
                                    </li>
                                    <li>
                                        Affiliated to State Medical University – PG Courses
                                    </li>
                                </ul>
                                <hr>
                            </div>
                        </div>
                    </div>
                </div>
    </section>


    <!-- Facilities section -->
    <section id="facilities" class="section">
        <div class="container">
            <h2>Facilities</h2>
            <div class="facility-grid">
                <div class="facility-item btn btn-primary">Hostel</div>
                <div class="facility-item btn btn-outline-secondary">Sports & Activities</div>
                <div class="facility-item btn btn-outline-info">Canteen</div>
                <div class="facility-item btn btn-outline-warning">Wi-Fi Enabled Campus</div>
                <div class="facility-item btn btn-outline-success">Transport</div>
            </div>
        </div>
    </section>

    <!-- Administration & Leadership -->
    <section class="section bg-light">
        <div class="container">
            <h2>Leadership</h2>
            <ul class="leadership-list">
                <li><strong>Principal and Medical Superintendent Details</strong> – <a
                        href="{{ url('principal') }}">Principal and Medical Superintendent Details</a></li>
                <li><strong>Vice-Chancellor & Registrar</strong> – <a href="{{ url('RKDF-University') }}">Vice-Chancellor &
                        Registrar</a></li>
                <li><strong>Teaching Staff</strong> – <a href="Documents\Teaching Staff 2025.pdf" target="_blank">Teaching
                        Staff</a></li>
                <li><strong>Non-Teaching Staff</strong> – <a href="Documents\Non Teaching Staff 2025.pdf"
                        target="_blank">Non-Teaching Staff</a></li>
            </ul>
        </div>
    </section>

    <!-- Insitute Departments -->
    <section class="section bg-light">
        <div class="container">
            <h2>Institute Departments</h2>
            <p>Click on indivdual department link to view details:</p>
            <ul>
                <li><a href="{{ url('department-Samhita-Siddhanta-Sanskrit') }}" target="_self">Samhita Siddhanta & Sanskrit</a></li>
                <li><a href="{{ url('department-Rachana-Sharira') }}" target="_self">Rachana Sharira</a></li>
                <li><a href="{{ url('department-Kriya-Sharira') }}" target="_self">Kriya Sharira</a></li>
                <li><a href="{{ url('department-Dravyaguna') }}" target="_self">Dravyaguna</a></li>
                <li><a href="{{ url('department-Rasashastra-Bhaishajyakalpana') }}" target="_self">Rasashastra & Bhaishajyakalpana</a></li>
                <li><a href="{{ url('department-Roga-Nidan-Vikriti-Vigyan') }}" target="_self">Roga Nidan & Vikriti Vigyan</a></li>
                <li><a href="{{ url('department-Agada-Tantra') }}" target="_self">Agada Tantra</a></li>
                <li><a href="{{ url('department-Swasthavritta-Yoga') }}" target="_self">Swasthavritta & Yoga</a></li>
                <li><a href="{{ url('department-Kayachikitsa') }}" target="_self">Kayachikitsa</a></li>
                <li><a href="{{ url('department-Panchakarma') }}" target="_self">Panchakarma</a></li>
                <li><a href="{{ url('department-Shalya-Tantra') }}" target="_self">Shalya Tantra</a></li>
                <li><a href="{{ url('department-Shalakya-Tantra') }}" target="_self">Shalakya Tantra</a></li>
                <li><a href="{{ url('department-Prasuti-Tantra-Stree-Roga') }}" target="_self">Prasuti Tantra & Stree Roga</a></li>
                <li><a href="{{ url('department-Kaumarabhritya') }}" target="_self">Kaumarabhritya</a></li>
            </ul>
        </div>
    </section>

    <!-- Courses, Intake & Fees -->
    <section id="courses" class="section">
        <div class="container">
            <h2>Courses,
                Intake & Fees</h2>
            <p>Find details about all courses offered,
                intake capacity,
                and fee structure for the current academic session: </p><a href="{{ url('RKCAMS-Course') }}"
                class="btn primary">View Courses & Fees</a>
        </div>
    </section>

    <!-- Students Lists -->
    <section class="section bg-light">
        <div class="container">
            <h2>Student Lists</h2>
            <p>Download or view student lists by year session:</p>
            <ul>
                <li><a href="{{ url('Documents\Student List_rkcams.2024-25 ncism.pdf') }}" target="_blank">2024-25
                        Session</a></li>
                <li><a href="{{ url('Documents\student List 2023-24.pdf') }}" target="_blank">2023-24 Session</a></li>
                <li><a href="{{ url('Documents\student List 2022-23.pdf') }}" target="_blank">2022-23 Session</a></li>
                <li><a href="{{ url('Documents\Student List 2021-22.pdf') }}" target="_blank">2021-22 Session</a></li>
            </ul>
        </div>
    </section>

    <!-- Research & Events -->
    <section class="section">
        <div class="container">
            <h2>Research & CME Programs</h2>
            <ul>
                <li><a href="{{ url('Documents\Publications.pdf') }}" target="_blank">Research Publications</a></li>
                <li><a href="{{ url('CME') }}">CME Programmes</a></li>
                <li><a href="#" target="_blank">Awards & Achievements</a></li>
            </ul>
        </div>
    </section>


    <!-- Results -->
    <section class="section">
        <div class="container">
            <h2>Results</h2>
            <ul>
                <li><a href="#">Results</a></li>
            </ul>
        </div>
    </section>


    <!-- Recognition -->
    <section class="section">
        <div class="container">
            <h2>Recognition</h2>
            <ul>
                <li><a href="{{ url('Documents\NCSIM_Permission\LOP-BAMS_YEAR_2025-2026.pdf') }}"
                        target="_blank">Recognition</a></li>
            </ul>
        </div>
    </section>
@endsection
