@extends('layouts.app')

@section('title', 'Department of Rasashastra & Bhaishajyakalpana | Ayurvedic Pharmaceutics and Formulation Science')
@section('meta_description', 'Department of Rasashastra and Bhaishajyakalpana specializing in Ayurvedic pharmaceutics, herbal and mineral drug preparation, classical formulations, pharmaceutical laboratories, and GMP-based medicine manufacturing training.')

@section('content')
    <!-- Optional: Add your custom styles here -->
    <style>
        /* =========================
        GLOBAL STYLES
        ========================= */

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', 'Open Sans', Arial, sans-serif;
            font-size: 16px;
            line-height: 1.7;
            color: #333;
            background-color: #ffffff;
        }


        ul {
            list-style-image: url('bullet.png');
            /* Path to your bullet image */
            list-style-type: disc;
            /* Fallback if image is not available */
        }

        h1,
        h2,
        h3 {
            font-family: 'Poppins', 'Montserrat', sans-serif;
            color: #1f2a44;
            margin-bottom: 15px;
        }

        h1 {
            font-size: 36px;
        }

        h2 {
            font-size: 28px;
        }

        p {
            margin-bottom: 15px;
        }

        a {
            text-decoration: none;
            color: #1a4ed8;
        }

        a:hover {
            text-decoration: underline;
        }

        /* =========================
                                                    LAYOUT
                                                    ========================= */

        .container {
            max-width: 1100px;
            margin: auto;
            padding: 0 20px;
        }

        .section {
            padding: 60px 0;
        }

        .bg-light {
            background-color: #f7f9fc;
        }

        .bg-primary {
            background-color: #1f2a44;
        }

        /* =========================
                                                    HERO SECTION
                                                    ========================= */

        .hero-section {
            background: linear-gradient(rgba(31, 42, 68, 0.7),
                    rgba(31, 42, 68, 0.7)),
                url('campus-photo.jpg') center/cover no-repeat;
            text-align: center;
            padding: 100px 20px;
            color: #ffffff;
        }

        .hero-section h1 {
            color: #ffffff;
            font-size: 42px;
        }

        .hero-section p {
            font-size: 18px;
            margin-bottom: 30px;
        }

        /* =========================
                                                    BUTTONS
                                                    ========================= */

        .btn {
            display: inline-block;
            padding: 12px 26px;
            margin: 5px;
            border-radius: 6px;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .btn.primary {
            background-color: #f0b429;
            color: #1f2a44;
        }

        .btn.primary:hover {
            background-color: #d99b1f;
        }

        .btn.secondary {
            background-color: transparent;
            border: 2px solid #ffffff;
            color: #ffffff;
        }

        .btn.secondary:hover {
            background-color: #ffffff;
            color: #1f2a44;
        }

        /* =========================
                                                    LISTS & CONTENT
                                                    ========================= */

        .strength-list,
        .leadership-list,
        .important-links {
            list-style: none;
            padding-left: 0;
        }

        .strength-list li,
        .leadership-list li {
            padding: 10px 0;
            padding-left: 28px;
            position: relative;
        }

        .strength-list li::before {
            content: "✔";
            position: absolute;
            left: 0;
            color: #1a4ed8;
            font-weight: bold;
        }

        /* =========================
                                                    FACILITIES GRID
                                                    ========================= */

        .facility-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
            gap: 20px;
            margin-top: 30px;
        }

        .facility-item {
            background: #c9c7bf;
            padding: 25px;
            text-align: center;
            border-radius: 10px;
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.08);
            font-weight: 600;
        }

        /* =========================
                                                    LINKS SECTION
                                                    ========================= */

        .important-links li {
            margin-bottom: 10px;
        }

        .important-links a {
            color: #ffffff;
            font-weight: 500;
        }

        .section {
            padding: 30px 0;
        }

        /* =========================
                                                    FOOTER
                                                    ========================= */

        .footer {
            background-color: #f1f3f6;
            text-align: center;
            font-size: 14px;
            color: #666;
        }

        .footer p {
            margin: 0;
        }

        /* =========================
                                                    RESPONSIVE DESIGN
                                                    ========================= */

        @media (max-width: 768px) {
            h1 {
                font-size: 30px;
            }

            h2 {
                font-size: 24px;
            }

            .hero-section {
                padding: 70px 20px;
            }

            .btn {
                width: 100%;
                max-width: 280px;
            }
        }
    </style>
<div class="container my-5">

    <!-- ================= PAGE HEADER ================= -->
    <header class="text-center mb-5">
        <h1 class="fw-bold">Department of Rasashastra & Bhaishajyakalpana</h1>
        <p class="text-muted">
            Ayurvedic Pharmaceutics • Drug Formulation • Herbal & Mineral Medicines • Classical Pharmacy Sciences
        </p>
    </header>


    <!-- ================= Department Overview ================= -->
    <section class="mb-5">
        <h2 class="border-bottom pb-2 mb-3">Department Overview</h2>

        <p class="text-justify">
            The Department of Rasashastra & Bhaishajyakalpana focuses on the science of Ayurvedic
            pharmaceutics, including preparation, processing, purification, standardization, and
            safe dispensing of herbal, mineral, and herbo-mineral medicines. Students receive
            hands-on training in classical formulations such as Churna, Vati, Avaleha, Taila, Ghrita,
            Bhasma, and Kupipakwa preparations while learning modern pharmaceutical principles,
            quality control methods, and GMP-based practices.
        </p>

        <ul>
            <li>Herbal and mineral drug preparation techniques</li>
            <li>Classical Ayurvedic formulations & dosage forms</li>
            <li>Drug standardization & quality testing</li>
            <li>Safe pharmaceutical manufacturing practices</li>
        </ul>
    </section>


    <!-- ================= Vision & Mission ================= -->
    <section class="mb-5">
        <h2 class="border-bottom pb-2 mb-3">Vision & Mission</h2>

        <div class="row g-4">

            <div class="col-md-6">
                <div class="card shadow-sm h-100">
                    <div class="card-body">
                        <h5 class="fw-semibold">Vision</h5>
                        <p>
                            To become a leading center for Ayurvedic pharmaceutical sciences by promoting
                            safe, scientific, and standardized preparation of traditional medicines.
                        </p>
                    </div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="card shadow-sm h-100">
                    <div class="card-body">
                        <h5 class="fw-semibold">Mission</h5>
                        <ul>
                            <li>Deliver practical training in drug formulation</li>
                            <li>Encourage pharmaceutical research & innovation</li>
                            <li>Promote GMP-based medicine production</li>
                            <li>Ensure quality, safety, and efficacy of Ayurvedic drugs</li>
                        </ul>
                    </div>
                </div>
            </div>

        </div>
    </section>


    <!-- ================= Courses ================= -->
    <section class="mb-5">
        <h2 class="border-bottom pb-2 mb-3">Courses & Teaching Programs</h2>

        <div class="table-responsive">
            <table class="table table-bordered table-striped align-middle">
                <thead class="table-light">
                <tr>
                    <th>Program</th>
                    <th>Year</th>
                    <th>Subject</th>
                    <th>Component</th>
                </tr>
                </thead>
                <tbody>
                <tr>
                    <td>BAMS</td>
                    <td>2nd Professional</td>
                    <td>Rasashastra & Bhaishajyakalpana</td>
                    <td>Theory + Practical</td>
                </tr>
                <tr>
                    <td>BAMS</td>
                    <td>2nd Professional</td>
                    <td>Pharmaceutical Preparations</td>
                    <td>Lab Training</td>
                </tr>
                <tr>
                    <td>Advanced Workshops</td>
                    <td>Special</td>
                    <td>Drug Standardization & GMP</td>
                    <td>Hands-on</td>
                </tr>
                </tbody>
            </table>
        </div>
    </section>


    <!-- ================= Faculty ================= -->
    <section class="mb-5">
        <h2 class="border-bottom pb-2 mb-3">Faculty & Staff</h2>

        <div class="row g-4">

            <div class="col-md-4">
                <div class="card text-center shadow-sm h-100">
                    <div class="card-body">
                        <h5 class="fw-bold">Dr. V. Deshmukh</h5>
                        <p class="text-muted mb-1">Professor & Head</p>
                        <small>MD (Rasashastra) | Pharmaceutics Specialist</small>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card text-center shadow-sm h-100">
                    <div class="card-body">
                        <h5 class="fw-bold">Dr. P. Kulkarni</h5>
                        <p class="text-muted mb-1">Assistant Professor</p>
                        <small>Formulation & Drug Standardization Expert</small>
                    </div>
                </div>
            </div>

        </div>
    </section>


    <!-- ================= Infrastructure ================= -->
    <section class="mb-5">
        <h2 class="border-bottom pb-2 mb-3">Infrastructure & Facilities</h2>

        <div class="row row-cols-1 row-cols-md-2 g-2">
            <div class="col">✔ Pharmaceutical Laboratory</div>
            <div class="col">✔ GMP-Compliant Pharmacy Unit</div>
            <div class="col">✔ Pulverization & Mixing Equipment</div>
            <div class="col">✔ Heating & Furnace Units for Bhasma Preparation</div>
            <div class="col">✔ Quality Control & Testing Lab</div>
            <div class="col">✔ Raw Drug Storage Room</div>
        </div>
    </section>


    <!-- ================= Teaching Methodology ================= -->
    <section class="mb-5">
        <h2 class="border-bottom pb-2 mb-3">Teaching Methodology</h2>

        <ul>
            <li>Hands-on preparation of classical formulations</li>
            <li>Demonstration of purification (Shodhana) techniques</li>
            <li>Laboratory-based pharmaceutical experiments</li>
            <li>Batch manufacturing training</li>
            <li>Quality control & safety testing</li>
        </ul>
    </section>


    <!-- ================= Research ================= -->
    <section class="mb-5">
        <h2 class="border-bottom pb-2 mb-3">Research & Publications</h2>

        <ul>
            <li>Standardization of Ayurvedic formulations</li>
            <li>Safety evaluation of herbo-mineral medicines</li>
            <li>Development of new dosage forms</li>
            <li>Peer-reviewed publications & patents</li>
        </ul>
    </section>


    <!-- ================= Activities ================= -->
    <section class="mb-5">
        <h2 class="border-bottom pb-2 mb-3">Academic & Co-Curricular Activities</h2>

        <ul>
            <li>Pharmacy workshops & training programs</li>
            <li>Industrial visits to GMP units</li>
            <li>Drug manufacturing demonstrations</li>
            <li>Scientific exhibitions & seminars</li>
        </ul>
    </section>


    <!-- ================= Student Support ================= -->
    <section class="mb-5">
        <h2 class="border-bottom pb-2 mb-3">Student Support</h2>

        <ul>
            <li>Practical manuals & SOP guidelines</li>
            <li>Formulation record books</li>
            <li>Mentoring & research supervision</li>
            <li>Entrepreneurship guidance for Ayurvedic pharmacy</li>
        </ul>
    </section>


    <!-- ================= Gallery ================= -->
    <section class="mb-5">
        <h2 class="border-bottom pb-2 mb-3">Photo & Media Gallery</h2>

        <div class="row g-3">
            <div class="col-md-3">
                <img src="/images/rasa1.jpg" class="img-fluid rounded" alt="Pharmaceutical Lab">
            </div>
            <div class="col-md-3">
                <img src="/images/rasa2.jpg" class="img-fluid rounded" alt="Drug Preparation Process">
            </div>
            <div class="col-md-3">
                <img src="/images/rasa3.jpg" class="img-fluid rounded" alt="GMP Unit">
            </div>
            <div class="col-md-3">
                <img src="/images/rasa4.jpg" class="img-fluid rounded" alt="Formulation Demonstration">
            </div>
        </div>
    </section>

</div>
@endsection
