@extends('layouts.app')

@section('title', 'Department of Prasuti Tantra & Stree Roga | Ayurvedic Obstetrics and Gynecology')
@section('meta_description', 'Department of Prasuti Tantra and Stree Roga offering Ayurvedic obstetrics, gynecology,
    antenatal care, postnatal care, infertility management, women’s wellness clinics, and clinical training with OPD/IPD and
    labour room facilities.')

@section('content')
    <!-- Optional: Add your custom styles here -->
    <style>
        /* =========================
            GLOBAL STYLES
            ========================= */

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', 'Open Sans', Arial, sans-serif;
            font-size: 16px;
            line-height: 1.7;
            color: #333;
            background-color: #ffffff;
        }


        ul {
            list-style-image: url('bullet.png');
            /* Path to your bullet image */
            list-style-type: disc;
            /* Fallback if image is not available */
        }

        h1,
        h2,
        h3 {
            font-family: 'Poppins', 'Montserrat', sans-serif;
            color: #1f2a44;
            margin-bottom: 15px;
        }

        h1 {
            font-size: 36px;
        }

        h2 {
            font-size: 28px;
        }

        p {
            margin-bottom: 15px;
        }

        a {
            text-decoration: none;
            color: #1a4ed8;
        }

        a:hover {
            text-decoration: underline;
        }

        /* =========================
                                                        LAYOUT
                                                        ========================= */

        .container {
            max-width: 1100px;
            margin: auto;
            padding: 0 20px;
        }

        .section {
            padding: 60px 0;
        }

        .bg-light {
            background-color: #f7f9fc;
        }

        .bg-primary {
            background-color: #1f2a44;
        }

        /* =========================
                                                        HERO SECTION
                                                        ========================= */

        .hero-section {
            background: linear-gradient(rgba(31, 42, 68, 0.7),
                    rgba(31, 42, 68, 0.7)),
                url('campus-photo.jpg') center/cover no-repeat;
            text-align: center;
            padding: 100px 20px;
            color: #ffffff;
        }

        .hero-section h1 {
            color: #ffffff;
            font-size: 42px;
        }

        .hero-section p {
            font-size: 18px;
            margin-bottom: 30px;
        }

        /* =========================
                                                        BUTTONS
                                                        ========================= */

        .btn {
            display: inline-block;
            padding: 12px 26px;
            margin: 5px;
            border-radius: 6px;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .btn.primary {
            background-color: #f0b429;
            color: #1f2a44;
        }

        .btn.primary:hover {
            background-color: #d99b1f;
        }

        .btn.secondary {
            background-color: transparent;
            border: 2px solid #ffffff;
            color: #ffffff;
        }

        .btn.secondary:hover {
            background-color: #ffffff;
            color: #1f2a44;
        }

        /* =========================
                                                        LISTS & CONTENT
                                                        ========================= */

        .strength-list,
        .leadership-list,
        .important-links {
            list-style: none;
            padding-left: 0;
        }

        .strength-list li,
        .leadership-list li {
            padding: 10px 0;
            padding-left: 28px;
            position: relative;
        }

        .strength-list li::before {
            content: "✔";
            position: absolute;
            left: 0;
            color: #1a4ed8;
            font-weight: bold;
        }

        /* =========================
                                                        FACILITIES GRID
                                                        ========================= */

        .facility-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
            gap: 20px;
            margin-top: 30px;
        }

        .facility-item {
            background: #c9c7bf;
            padding: 25px;
            text-align: center;
            border-radius: 10px;
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.08);
            font-weight: 600;
        }

        /* =========================
                                                        LINKS SECTION
                                                        ========================= */

        .important-links li {
            margin-bottom: 10px;
        }

        .important-links a {
            color: #ffffff;
            font-weight: 500;
        }

        .section {
            padding: 30px 0;
        }

        /* =========================
                                                        FOOTER
                                                        ========================= */

        .footer {
            background-color: #f1f3f6;
            text-align: center;
            font-size: 14px;
            color: #666;
        }

        .footer p {
            margin: 0;
        }

        /* =========================
                                                        RESPONSIVE DESIGN
                                                        ========================= */

        @media (max-width: 768px) {
            h1 {
                font-size: 30px;
            }

            h2 {
                font-size: 24px;
            }

            .hero-section {
                padding: 70px 20px;
            }

            .btn {
                width: 100%;
                max-width: 280px;
            }
        }
    </style>
    <div class="container my-5">

        <!-- ================= PAGE HEADER ================= -->
        <header class="text-center mb-5">
            <h1 class="fw-bold">Department of Prasuti Tantra & Stree Roga</h1>
            <p class="text-muted">
                Ayurvedic Obstetrics • Gynecology • Women’s Health • Maternal & Reproductive Care
            </p>
        </header>


        <!-- ================= Department Overview ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Department Overview</h2>

            <p class="text-justify">
                The Department of Prasuti Tantra & Stree Roga focuses on comprehensive healthcare
                for women across all stages of life. The department integrates classical Ayurvedic
                principles with modern obstetric and gynecological practices to deliver safe maternity
                care, reproductive health management, and preventive wellness services. Students gain
                hands-on clinical exposure in antenatal, postnatal, infertility, and gynecological disorders
                through structured OPD, IPD, and labour room training.
            </p>

            <ul>
                <li>Antenatal and postnatal maternal care</li>
                <li>Management of menstrual and hormonal disorders</li>
                <li>Infertility and reproductive health counseling</li>
                <li>Preventive women’s wellness programs</li>
            </ul>
        </section>


        <!-- ================= Vision & Mission ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Vision & Mission</h2>

            <div class="row g-4">

                <div class="col-md-6">
                    <div class="card shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-semibold">Vision</h5>
                            <p>
                                To become a leading center for Ayurvedic obstetric and gynecological
                                education by promoting safe motherhood, reproductive health, and holistic
                                women’s wellness.
                            </p>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="card shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-semibold">Mission</h5>
                            <ul>
                                <li>Deliver quality maternal and gynecological care</li>
                                <li>Enhance practical clinical training for students</li>
                                <li>Promote research in women’s health sciences</li>
                                <li>Encourage preventive and lifestyle-based therapies</li>
                            </ul>
                        </div>
                    </div>
                </div>

            </div>
        </section>


        <!-- ================= Courses & Teaching Programs ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Courses & Teaching Programs</h2>

            <div class="table-responsive">
                <table class="table table-bordered table-striped align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>Program</th>
                            <th>Year</th>
                            <th>Subject</th>
                            <th>Component</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>BAMS</td>
                            <td>Final Professional</td>
                            <td>Prasuti Tantra & Stree Roga</td>
                            <td>Theory + Clinical Posting</td>
                        </tr>
                        <tr>
                            <td>Internship</td>
                            <td>Clinical Rotation</td>
                            <td>Labour Room & OPD Training</td>
                            <td>Hands-on Practice</td>
                        </tr>
                        <tr>
                            <td>MD (PG)</td>
                            <td>Specialization</td>
                            <td>Advanced Obstetrics & Gynecology</td>
                            <td>Research + Clinical Work</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </section>


        <!-- ================= Faculty & Staff ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Faculty & Staff</h2>

            <div class="row g-4">

                <div class="col-md-4">
                    <div class="card text-center shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-bold">Dr. S. Verma</h5>
                            <p class="text-muted mb-1">Professor & Head</p>
                            <small>MD (Prasuti Tantra) | Maternal Care Specialist</small>
                        </div>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="card text-center shadow-sm h-100">
                        <div class="card-body">
                            <h5 class="fw-bold">Dr. K. Patel</h5>
                            <p class="text-muted mb-1">Assistant Professor</p>
                            <small>Gynecology & Infertility Management Expert</small>
                        </div>
                    </div>
                </div>

            </div>
        </section>


        <!-- ================= Infrastructure & Facilities ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Infrastructure & Facilities</h2>

            <div class="row row-cols-1 row-cols-md-2 g-2">
                <div class="col">✔ Dedicated Antenatal OPD Rooms</div>
                <div class="col">✔ Labour Room & Delivery Unit</div>
                <div class="col">✔ Minor Operation Theatre</div>
                <div class="col">✔ Gynecology Examination Unit</div>
                <div class="col">✔ Postnatal Ward & Recovery Beds</div>
                <div class="col">✔ Diagnostic & Ultrasound Support</div>
            </div>
        </section>


        <!-- ================= Teaching Methodology ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Teaching Methodology</h2>

            <ul>
                <li>Clinical case-based teaching</li>
                <li>Labour room demonstrations</li>
                <li>Bedside patient care training</li>
                <li>Simulation-based skill workshops</li>
                <li>Seminars, presentations, and journal clubs</li>
            </ul>
        </section>


        <!-- ================= Research & Publications ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Research & Publications</h2>

            <ul>
                <li>Maternal and neonatal health outcome studies</li>
                <li>Infertility and hormonal disorder research</li>
                <li>Clinical trials on Ayurvedic formulations</li>
                <li>National and international journal publications</li>
            </ul>
        </section>


        <!-- ================= Academic & Co-Curricular Activities ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Academic & Co-Curricular Activities</h2>

            <ul>
                <li>Women’s health awareness camps</li>
                <li>Antenatal education workshops</li>
                <li>Guest lectures by obstetrics specialists</li>
                <li>Community maternal care initiatives</li>
            </ul>
        </section>


        <!-- ================= Student Support ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Student Support</h2>

            <ul>
                <li>Clinical logbooks & procedural manuals</li>
                <li>Mentorship & bedside supervision</li>
                <li>Research and dissertation guidance</li>
                <li>Internship & career counseling</li>
            </ul>
        </section>


        <!-- ================= Photo & Media Gallery ================= -->
        <section class="mb-5">
            <h2 class="border-bottom pb-2 mb-3">Photo & Media Gallery</h2>

            <div class="row g-3">
                <div class="col-md-3">
                    <img src="/images/prasuti1.jpg" class="img-fluid rounded" alt="Antenatal Clinic">
                </div>
                <div class="col-md-3">
                    <img src="/images/prasuti2.jpg" class="img-fluid rounded" alt="Labour Room Facility">
                </div>
                <div class="col-md-3">
                    <img src="/images/prasuti3.jpg" class="img-fluid rounded" alt="Clinical Teaching Session">
                </div>
                <div class="col-md-3">
                    <img src="/images/prasuti4.jpg" class="img-fluid rounded" alt="Women Health Camp">
                </div>
            </div>
        </section>
    </div>
@endsection
