<?php
// Sample data (replace with your actual data retrieval logic)
$data = [
    2023 => [
        'BE' => [
            ['name' => 'Analog Circuits', 'path' => 'pdfs/2023/ECE/AnalogCircuits.pdf'],
            ['name' => 'Digital Signal Processing', 'path' => 'pdfs/2023/ECE/DSP.pdf'],
           ],
        'ECE' => [
            ['name' => 'Analog Circuits', 'path' => 'pdfs/2023/ECE/AnalogCircuits.pdf'],
            ['name' => 'Digital Signal Processing', 'path' => 'pdfs/2023/ECE/DSP.pdf'],
        ],
    ],
    2022 => [
        'BE' => [
            ['name' => 'BE - 1011     Engineering Chemistry.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/BE - 1011     Engineering Chemistry.pdf'],
            ['name' => 'BE -1031.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/BE -1031.pdf'],
            ['name' => 'BE 2031.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/BE 2031.pdf'],
            ['name' => 'BE 2041 (2).pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/BE 2041 (2).pdf'],
            ['name' => 'BE 2041.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/BE 2041.pdf'],
            ['name' => 'BE 3051.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/BE 3051.pdf'],
            ['name' => 'BE(ME) 5031.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/BE(ME) 5031.pdf'],
            ['name' => 'BE- 1041.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/BE- 1041.pdf'],
            ['name' => 'BE- 1051.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/BE- 1051.pdf'],
            ['name' => 'BE- 2021 (ENGINEERING METHEMATICS).pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/BE- 2021 (ENGINEERING METHEMATICS).pdf'],
            ['name' => 'BE- 3051.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/BE- 3051.pdf'],
            ['name' => 'BE-2011.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/BE-2011.pdf'],
            ['name' => 'BE-2051 (PROGRAMMING FOR PROBLEM SOLVING).pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/BE-2051 (PROGRAMMING FOR PROBLEM SOLVING).pdf'],
            ['name' => 'BE-3051.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/BE-3051.pdf'],
            ['name' => 'CE - 501    Transportation Road Engineering.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CE - 501    Transportation Road Engineering.pdf'],
            ['name' => 'CE -3011 (ENGG. MATHEMATICS- III).pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CE -3011 (ENGG. MATHEMATICS- III).pdf'],
            ['name' => 'CE 3021.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CE 3021.pdf'],
            ['name' => 'CE 4051.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CE 4051.pdf'],
            ['name' => 'CE 5011.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CE 5011.pdf'],
            ['name' => 'CE 6021.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CE 6021.pdf'],
            ['name' => 'CE-  4031.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CE-  4031.pdf'],
            ['name' => 'CE-  4041.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CE-  4041.pdf'],
            ['name' => 'CE-  5031.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CE-  5031.pdf'],
            ['name' => 'CE-  5041.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CE-  5041.pdf'],
            ['name' => 'CE- 3011.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CE- 3011.pdf'],
            ['name' => 'CE- 3021.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CE- 3021.pdf'],
            ['name' => 'CE- 3031.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CE- 3031.pdf'],
            ['name' => 'CE- 3041 (BDD).pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CE- 3041 (BDD).pdf'],
            ['name' => 'CE- 3041.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CE- 3041.pdf'],
            ['name' => 'CE- 6031.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CE- 6031.pdf'],
            ['name' => 'CE- 6041.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CE- 6041.pdf'],
            ['name' => 'CE- 7011.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CE- 7011.pdf'],
            ['name' => 'CE- 703 (DESIGN OF HYDRAULIC STRUCTURES).pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CE- 703 (DESIGN OF HYDRAULIC STRUCTURES).pdf'],
            ['name' => 'CE- 801.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CE- 801.pdf'],
            ['name' => 'CE-3031.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CE-3031.pdf'],
            ['name' => 'CE-3051 Vale Education lateral.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CE-3051 Vale Education lateral.pdf'],
            ['name' => 'CE-4021 Concrete Technology.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CE-4021 Concrete Technology.pdf'],
            ['name' => 'CE-502 (BE).pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CE-502 (BE).pdf'],
            ['name' => 'CE-702          Advance Structure Design ??? II   (RCC).pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CE-702          Advance Structure Design ??? II   (RCC).pdf'],
            ['name' => 'CE-802         Theory of Structure.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CE-802         Theory of Structure.pdf'],
            ['name' => 'CE-8031(A).pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CE-8031(A).pdf'],
            ['name' => 'CE-8101.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CE-8101.pdf'],
            ['name' => 'CS- 3011.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CS- 3011.pdf'],
            ['name' => 'CS- 4041 (DESIGN & ANALYSIS OF ALGORITHMS).pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CS- 4041 (DESIGN & ANALYSIS OF ALGORITHMS).pdf'],
            ['name' => 'CS- 5041.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CS- 5041.pdf'],
            ['name' => 'CS- 8011.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CS- 8011.pdf'],
            ['name' => 'CS-3021 data sructure and algorithm.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CS-3021 data sructure and algorithm.pdf'],
            ['name' => 'CS-3021 data sructure.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CS-3021 data sructure.pdf'],
            ['name' => 'CS-3031 Computer Organization & Artitacture.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CS-3031 Computer Organization & Artitacture.pdf'],
            ['name' => 'CS-3041 Operating Systems Lateral.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CS-3041 Operating Systems Lateral.pdf'],
            ['name' => 'CS-3051 Vale Education lateral.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CS-3051 Vale Education lateral.pdf'],
            ['name' => 'CS-4021 Database Management  system.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CS-4021 Database Management  system.pdf'],
            ['name' => 'CS-5021 oop paper.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CS-5021 oop paper.pdf'],
            ['name' => 'CS-5031(A) Discrete Structure.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CS-5031(A) Discrete Structure.pdf'],
            ['name' => 'CS-6011 Cloud Computing.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CS-6011 Cloud Computing.pdf'],
            ['name' => 'CS-6021   Compiler Design.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CS-6021   Compiler Design.pdf'],
            ['name' => 'CS-6031 Artifical Intelligence.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CS-6031 Artifical Intelligence.pdf'],
            ['name' => 'CS-6041(B).pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CS-6041(B).pdf'],
            ['name' => 'CS-8021(A) High performance computing.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CS-8021(A) High performance computing.pdf'],
            ['name' => 'CSE -3011 (ENGG. MATHEMATICS- III).pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CSE -3011 (ENGG. MATHEMATICS- III).pdf'],
            ['name' => 'CSE- 701 (DISTRIBUTED COMPUTATION).pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CSE- 701 (DISTRIBUTED COMPUTATION).pdf'],
            ['name' => 'CSE- 702 (SOFT COMPUTING) -.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CSE- 702 (SOFT COMPUTING) -.pdf'],
            ['name' => 'CSE- 703 (WEB TECHNOLOGY).pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CSE- 703 (WEB TECHNOLOGY).pdf'],
            ['name' => 'CSE-304 Operating System.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CSE-304 Operating System.pdf'],
            ['name' => 'CSE-7043.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CSE-7043.pdf'],
            ['name' => 'CSE-8031- IMAGE PROCESSING AND COMPUTER VISION).pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/CSE-8031- IMAGE PROCESSING AND COMPUTER VISION).pdf'],
            ['name' => 'EC - 3031    Digital Electronic.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EC - 3031    Digital Electronic.pdf'],
            ['name' => 'EC - 3031 (DIGITAL ELECTRONICS).pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EC - 3031 (DIGITAL ELECTRONICS).pdf'],
            ['name' => 'EC - 3041 (NETWORK ANALYSIS).pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EC - 3041 (NETWORK ANALYSIS).pdf'],
            ['name' => 'EC- 3021 lateral.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EC- 3021 lateral.pdf'],
            ['name' => 'EC- 3021.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EC- 3021.pdf'],
            ['name' => 'EC- 3041 (NETWORK ANALYSIS).pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EC- 3041 (NETWORK ANALYSIS).pdf'],
            ['name' => 'EC- 4011.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EC- 4011.pdf'],
            ['name' => 'EC- 5021.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EC- 5021.pdf'],
            ['name' => 'EC-3011 (ENVIRONMENTAL ENGINEERING).pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EC-3011 (ENVIRONMENTAL ENGINEERING).pdf'],
            ['name' => 'EC-3041.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EC-3041.pdf'],
            ['name' => 'EC-3051 Vale Education lateral.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EC-3051 Vale Education lateral.pdf'],
            ['name' => 'EC-4021  (ELECTRONIC INSTRUMENTATION).pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EC-4021  (ELECTRONIC INSTRUMENTATION).pdf'],
            ['name' => 'EC-4031     Analog Communication.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EC-4031     Analog Communication.pdf'],
            ['name' => 'EC-4041       Analog Circuit.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EC-4041       Analog Circuit.pdf'],
            ['name' => 'EC-4051      Control System.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EC-4051      Control System.pdf'],
            ['name' => 'EC-5011 Digital Communication.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EC-5011 Digital Communication.pdf'],
            ['name' => 'EC-601      Wireless Communication_D 2019.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EC-601      Wireless Communication_D 2019.pdf'],
            ['name' => 'EE & EX - 5031 Energy Conservation & Management.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EE & EX - 5031 Energy Conservation & Management.pdf'],
            ['name' => 'EE - 3031.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EE - 3031.pdf'],
            ['name' => 'EE - 5021.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EE - 5021.pdf'],
            ['name' => 'EE - 604     Electrical Power Generation.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EE - 604     Electrical Power Generation.pdf'],
            ['name' => 'EE - 6041(A)     Electrical Power Generation.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EE - 6041(A)     Electrical Power Generation.pdf'],
            ['name' => 'EE- 3031.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EE- 3031.pdf'],
            ['name' => 'EE- 3041 (NETWORK ANALYSIS).pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EE- 3041 (NETWORK ANALYSIS).pdf'],
            ['name' => 'EE- 4011.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EE- 4011.pdf'],
            ['name' => 'EE- 4051.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EE- 4051.pdf'],
            ['name' => 'EE-3011 (ENVIRONMENTAL ENGINEERING).pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EE-3011 (ENVIRONMENTAL ENGINEERING).pdf'],
            ['name' => 'EE-3051 Vale Education lateral.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EE-3051 Vale Education lateral.pdf'],
            ['name' => 'EE-4021.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EE-4021.pdf'],
            ['name' => 'EE-4031.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EE-4031.pdf'],
            ['name' => 'EE-6011        Microprocessors and Microcontroller.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EE-6011        Microprocessors and Microcontroller.pdf'],
            ['name' => 'EE-6031(A).pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EE-6031(A).pdf'],
            ['name' => 'EE-EX- 3021.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EE-EX- 3021.pdf'],
            ['name' => 'EE-EX- 3041 (NETWORK ANALYSIS).pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EE-EX- 3041 (NETWORK ANALYSIS).pdf'],
            ['name' => 'EE-EX- 3041.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EE-EX- 3041.pdf'],
            ['name' => 'EE-EX- 5041.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EE-EX- 5041.pdf'],
            ['name' => 'EE-EX- 6021.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EE-EX- 6021.pdf'],
            ['name' => 'EE-EX- 7021 (ELECTRICAL DRIVES).pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EE-EX- 7021 (ELECTRICAL DRIVES).pdf'],
            ['name' => 'EE-EX=3021.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EE-EX=3021.pdf'],
            ['name' => 'EX - 702       Power Electronics aniket.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EX - 702       Power Electronics aniket.pdf'],
            ['name' => 'EX- 3041 (NETWORK ANALYSIS).pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EX- 3041 (NETWORK ANALYSIS).pdf'],
            ['name' => 'EX- 4011.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EX- 4011.pdf'],
            ['name' => 'EX- 4051.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EX- 4051.pdf'],
            ['name' => 'EX- 5021.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EX- 5021.pdf'],
            ['name' => 'EX- 7011 (POWER ELECTRONICS).pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EX- 7011 (POWER ELECTRONICS).pdf'],
            ['name' => 'EX- 7021 (ELECTRICAL DRIVES).pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EX- 7021 (ELECTRICAL DRIVES).pdf'],
            ['name' => 'EX- 7031.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EX- 7031.pdf'],
            ['name' => 'EX-3011 (ENVIRONMENTAL ENGINEERING).pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EX-3011 (ENVIRONMENTAL ENGINEERING).pdf'],
            ['name' => 'EX-3031  Electrical Measurement and Measuring Instruments.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EX-3031  Electrical Measurement and Measuring Instruments.pdf'],
            ['name' => 'EX-3031 EMMI.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EX-3031 EMMI.pdf'],
            ['name' => 'EX-3051 Vale Education lateral.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EX-3051 Vale Education lateral.pdf'],
            ['name' => 'EX-4021.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EX-4021.pdf'],
            ['name' => 'EX-4031 Digital Electronics.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EX-4031 Digital Electronics.pdf'],
            ['name' => 'EX-6011        Microprocessors and Microcontroller.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EX-6011        Microprocessors and Microcontroller.pdf'],
            ['name' => 'EX-6031(A).pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/EX-6031(A).pdf'],
            ['name' => 'files.txt', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/files.txt'],
            ['name' => 'IT -3011 (ENGG. MATHEMATICS- III).pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/IT -3011 (ENGG. MATHEMATICS- III).pdf'],
            ['name' => 'IT- 7011 (SOFT COMPUTING).pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/IT- 7011 (SOFT COMPUTING).pdf'],
            ['name' => 'IT-3021 data sructure and algorithm.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/IT-3021 data sructure and algorithm.pdf'],
            ['name' => 'IT-3031 Computer Organization & Artitacture.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/IT-3031 Computer Organization & Artitacture.pdf'],
            ['name' => 'IT-3041 Operating Systems Lateral.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/IT-3041 Operating Systems Lateral.pdf'],
            ['name' => 'IT-3051 Vale Education lateral.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/IT-3051 Vale Education lateral.pdf'],
            ['name' => 'IT-5021 oop paper.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/IT-5021 oop paper.pdf'],
            ['name' => 'IT-5031 A       Theory of Computation.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/IT-5031 A       Theory of Computation.pdf'],
            ['name' => 'IT-5041(A)  internet and web technology.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/IT-5041(A)  internet and web technology.pdf'],
            ['name' => 'ME - 3031   Manufacturing Process.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/ME - 3031   Manufacturing Process.pdf'],
            ['name' => 'ME - 4031      Power Plant Engineering.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/ME - 4031      Power Plant Engineering.pdf'],
            ['name' => 'ME - 502    Fluid Mechanics.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/ME - 502    Fluid Mechanics.pdf'],
            ['name' => 'ME - 604   Mechanical Measurement & Metrology.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/ME - 604   Mechanical Measurement & Metrology.pdf'],
            ['name' => 'ME - 7031(B)     Tribology.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/ME - 7031(B)     Tribology.pdf'],
            ['name' => 'ME - 705      Automobile Engineering.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/ME - 705      Automobile Engineering.pdf'],
            ['name' => 'ME - 8021 (A)      Industrial Engineering & Operation Research.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/ME - 8021 (A)      Industrial Engineering & Operation Research.pdf'],
            ['name' => 'ME 2005.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/ME 2005.pdf'],
            ['name' => 'me 4021.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/me 4021.pdf'],
            ['name' => 'me 4031 power plant engg.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/me 4031 power plant engg.pdf'],
            ['name' => 'ME 7021(a).pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/ME 7021(a).pdf'],
            ['name' => 'ME- 3021 (STRENGTH OF MATERIAL).pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/ME- 3021 (STRENGTH OF MATERIAL).pdf'],
            ['name' => 'ME- 3031.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/ME- 3031.pdf'],
            ['name' => 'ME- 3041.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/ME- 3041.pdf'],
            ['name' => 'ME- 4011.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/ME- 4011.pdf'],
            ['name' => 'ME- 4041(MATERIAL SCIENCE & METALLURGY).pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/ME- 4041(MATERIAL SCIENCE & METALLURGY).pdf'],
            ['name' => 'ME- 4051.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/ME- 4051.pdf'],
            ['name' => 'ME- 501 (DYNAMICS OF MACHINERY).pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/ME- 501 (DYNAMICS OF MACHINERY).pdf'],
            ['name' => 'ME- 5021.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/ME- 5021.pdf'],
            ['name' => 'ME- 601.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/ME- 601.pdf'],
            ['name' => 'ME- 6021.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/ME- 6021.pdf'],
            ['name' => 'ME- 7011.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/ME- 7011.pdf'],
            ['name' => 'ME-3011 (ENVIRONMENTAL ENGINEERING).pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/ME-3011 (ENVIRONMENTAL ENGINEERING).pdf'],
            ['name' => 'ME-3011=Enveronmental Engineering.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/ME-3011=Enveronmental Engineering.pdf'],
            ['name' => 'ME-3021 Strength of Materials.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/ME-3021 Strength of Materials.pdf'],
            ['name' => 'ME-3041.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/ME-3041.pdf'],
            ['name' => 'ME-3051 Vale Education lateral.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/ME-3051 Vale Education lateral.pdf'],
            ['name' => 'ME-5011.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/ME-5011.pdf'],
            ['name' => 'ME-5041 Mechatronics.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/ME-5041 Mechatronics.pdf'],
            ['name' => 'ME-601     Gas Dynamics.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/ME-601     Gas Dynamics.pdf'],
            ['name' => 'ME-603     Hydraulic Machines -   .pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/ME-603     Hydraulic Machines -   .pdf'],
            ['name' => 'ME-6031  =2.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/ME-6031  =2.pdf'],
            ['name' => 'ME-6041 (C) Renawable Energy Technology.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/ME-6041 (C) Renawable Energy Technology.pdf'],
            ['name' => 'ME-605     Internal combustion eng -   (Autosaved).pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/ME-605     Internal combustion eng -   (Autosaved).pdf'],
            ['name' => 'ME-702.pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/ME-702.pdf'],
            ['name' => 'ME-7103     Material Handling equipment  -  .pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/ME-7103     Material Handling equipment  -  .pdf'],
            ['name' => 'ME-8031(C).pdf', 'path' => 'Content/Old_Question_Papers/DEC-2022/BE/ME-8031(C).pdf'],
        ],
        'MCA' => [
            ['name' => 'Electromagnetics', 'path' => 'pdfs/2022/ECE/EM.pdf'],
            ['name' => 'Communication Systems', 'path' => 'pdfs/2022/ECE/CommSys.pdf'],
        ],
        'MTECH' => [
            ['name' => 'Electromagnetics', 'path' => 'pdfs/2022/ECE/EM.pdf'],
            ['name' => 'Communication Systems', 'path' => 'pdfs/2022/ECE/CommSys.pdf'],
        ],
    ],
];

function checkMimeType($filePath) {
    $finfo = finfo_open(FILEINFO_MIME_TYPE);
    $mimeType = finfo_file($finfo, $filePath);
    finfo_close($finfo);
    return $mimeType;
}
?>

<!DOCTYPE html>
<html>

<head>
    <title>Question Papers</title>
    <style>
    body {
        font-family: sans-serif;
        background-color: #f4f4f4;
        margin: 20px;
    }

    h1 {
        text-align: center;
        color: #333;
    }

    details {
        border: 1px solid #ddd;
        margin-bottom: 10px;
        border-radius: 8px;
        background-color: #fff;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    }

    summary {
        padding: 15px;
        background-color: #e8f5e9;
        /* Light green */
        color: #2e7d32;
        /* Darker green */
        cursor: pointer;
        outline: none;
        border-bottom: 1px solid #ddd;
        border-radius: 8px 8px 0 0;
        font-weight: 600;
        transition: background-color 0.3s ease;
    }

    summary:hover {
        background-color: #dcedc8;
        /* Lighter green on hover */
    }

    details[open] summary {
        background-color: #c8e6c9;
        /* Even lighter green when open */
    }

    details ul {
        list-style: none;
        padding: 15px;
        margin: 0;
    }

    details ul li {
        padding: 8px 0;
        border-bottom: 1px solid #f0f0f0;
        color: #555;
    }

    details ul li:last-child {
        border-bottom: none;
    }

    .details ul li:before {
        content: "📄";
        margin-right: 8px;
        color: #81c784;
        /* Green icon */
    }

    details details summary {
        background-color: #e3f2fd;
        /* Light blue */
        color: #1976d2;
        /* Darker blue */
    }

    details details summary:hover {
        background-color: #bbdefb;
        /* Lighter blue on hover */
    }

    details details[open] summary {
        background-color: #90caf9;
    }

    .error {
            color: red;
            font-weight: bold;
        }
    </style>
</head>

<body>

    <h1>Question Papers</h1>

    <?php
    foreach ($data as $year => $branches) {
        echo '<details>';
        echo '<summary>' . $year . '</summary>';
        foreach ($branches as $branch => $papers) {
            echo '<details>';
            echo '<summary>' . $branch . '</summary>';
            echo '<ul>';
            foreach ($papers as $paper) {
                $filePath = $paper['path'];
                if (file_exists($filePath)) {
                    $mimeType = checkMimeType($filePath);
                    if ($mimeType === 'application/pdf') {
                        echo '<li><a href="' . $filePath . '" target="_blank">' . $paper['name'] . '</a></li>';
                    } else {
                        echo '<li class="error">Error: Invalid file type for ' . $paper['name'] . ' (MIME: ' . $mimeType . ')</li>';
                    }
                } else {
                    echo '<li class="error">Error: File not found for ' . $paper['name'] . ' (' . $filePath . ')</li>';
                }            }
            echo '</ul>';
            echo '</details>';
        }
        echo '</details>';
    }
    ?>

</body>

</html>