<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('stats', function (Blueprint $table) {
            $table->id();
            $table->string('title', 150);
            $table->string('slug', 150)->unique();
            $table->unsignedInteger('count')->default(0);
            $table->string('icon')->nullable();
            $table->string('color', 30)->default('success');
            $table->boolean('is_active')->default(true);

            $table->timestamps();
            $table->index(['is_active']);
            $table->index(['slug','is_active']);

            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('stats');
    }
};