<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Stat extends Model
{
   protected $fillable = [
        'title','slug','count','icon','color','is_active'
    ];

    protected static function booted()
    {
        static::saved(fn() => cache()->forget('dashboard.stats'));
        static::deleted(fn() => cache()->forget('dashboard.stats'));
    }

    public function scopeActive($q)
    {
        return $q->where('is_active',1);
    }
}