<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class EnquiryController extends Controller
{
   public function store(Request $request)
    {
        $validated = $request->validate([
            'name'    => 'required|string|max:100',
            'email'   => 'required|email:rfc,dns|max:150',
            'mobile'  => 'required|regex:/^[6-9]\d{9}$/',
            'message' => 'required|string|max:1000',
        ]);

        Enquiry::create([
            ...$validated,
            'ip_address' => $request->ip(),
            'user_agent' => substr($request->userAgent(), 0, 255),
        ]);

        return back()->with('success', 'Enquiry submitted successfully.');
    }
}

