<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function index()
    {
        try {
            $stats = cache()->remember(
            'dashboard.stats',
            600,
            fn() => Stat::active()->orderBy('id')->get()
            );

            return view('dashboard.index', compact('stats'));
        } catch (\Exception $e) {
            \Log::error('Dashboard Load Error: '.$e->getMessage());
            abort(500);
        }
    }
}